/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.attend.impl;

import cn.hutool.core.util.StrUtil;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtil;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.common.utils.validator.ValidatorUtils;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.FactorGroup;
import com.bcxin.platform.common.utils.validator.group.OneGroup;
import com.bcxin.platform.common.utils.validator.group.TwoGroup;
import com.bcxin.platform.domain.attend.AttendShift;
import com.bcxin.platform.dto.app.AppAttendShiftDto;
import com.bcxin.platform.dto.attend.AttendShiftDto;
import com.bcxin.platform.mapper.attend.AttendSchedulDetailMapper;
import com.bcxin.platform.mapper.attend.AttendShiftMapper;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.service.attend.AttendShiftService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class AttendShiftServiceImpl
implements AttendShiftService {
    @Autowired
    private AttendShiftMapper attendShiftMapper;
    @Autowired
    private AttendSchedulDetailMapper attendSchedulMapper;
    @Autowired
    private PerOrgRelationMapper perOrgRelationMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public AttendShift findById(Long id) {
        return this.attendShiftMapper.findById(id);
    }

    @Override
    public List<AttendShiftDto> selectList(AttendShiftDto searchDto) {
        if (!(searchDto.isDomainAdmin() || searchDto.getAdminDepartIds() != null && searchDto.getAdminDepartIds().size() != 0)) {
            return new ArrayList<AttendShiftDto>();
        }
        return this.attendShiftMapper.selectList(searchDto);
    }

    @Override
    public int saveBatch(List<AttendShift> shiftList) {
        for (AttendShift attendShift : shiftList) {
            this.update(attendShift);
        }
        return shiftList.size();
    }

    @Override
    public List<AppAttendShiftDto> findByAttendId(AttendShiftDto attendShift) {
        List<AppAttendShiftDto> list = this.attendShiftMapper.findByAttendId(attendShift);
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setLetterTag(AttendShiftServiceImpl.getLetterTag(i));
        }
        return list;
    }

    private static String getLetterTag(int index) {
        String[] letters = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        return letters[index % letters.length] + (index / letters.length > 0 ? Integer.valueOf(index / letters.length) : "");
    }

    @Override
    public void validateData(AttendShift attendShift) {
        attendShift.setCrossDay("0");
        ValidatorUtils.validateEntity((Object)((Object)attendShift), (Class[])new Class[]{AddGroup.class});
        if ("1".equals(attendShift.getShiftType())) {
            ValidatorUtils.validateEntity((Object)((Object)attendShift), (Class[])new Class[]{OneGroup.class});
            Date stratTime = DateUtil.convertStringToDate((String)(DateUtil.getCurrentDate() + " " + attendShift.getStartTime()));
            Date endTime = DateUtil.convertStringToDate((String)(DateUtil.getCurrentDate() + " " + attendShift.getEndTime()));
            if (stratTime.getTime() > endTime.getTime()) {
                endTime = DateUtils.addDays((Date)endTime, (int)1);
                attendShift.setCrossDay("1");
            }
            Integer hourDiff = DateUtil.dateDiffForMinutes((Date)stratTime, (Date)endTime);
            Integer restHourDiff = 0;
            if ("1".equals(attendShift.getNeedRest())) {
                ValidatorUtils.validateEntity((Object)((Object)attendShift), (Class[])new Class[]{FactorGroup.class});
                Date restStratTime = DateUtil.convertStringToDate((String)(DateUtil.getCurrentDate() + " " + attendShift.getRestStart()));
                Date restEndTime = DateUtil.convertStringToDate((String)(DateUtil.getCurrentDate() + " " + attendShift.getRestEnd()));
                if (restStratTime.getTime() > restEndTime.getTime()) {
                    restEndTime = DateUtils.addDays((Date)restEndTime, (int)1);
                }
                if (restStratTime.getTime() < stratTime.getTime() || restStratTime.getTime() > endTime.getTime()) {
                    throw new BusinessException("\u4f11\u606f\u5f00\u59cb\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef\uff01");
                }
                if (restEndTime.getTime() < stratTime.getTime() || restEndTime.getTime() > endTime.getTime()) {
                    throw new BusinessException("\u4f11\u606f\u7ed3\u675f\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef\uff01");
                }
                restHourDiff = DateUtil.dateDiffForMinutes((Date)restStratTime, (Date)restEndTime);
            }
            if (hourDiff - restHourDiff < 30) {
                throw new BusinessException("\u65f6\u95f4\u95f4\u9694\u592a\u77ed\uff0c\u5e94\u8be5\u4e0d\u5c11\u4e8e\uff08\u542b\uff0930\u5206\u949f\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u4e0b\u73ed\u65f6\u95f4\uff01");
            }
            attendShift.setShiftHour(BigDecimal.valueOf((double)(hourDiff - restHourDiff) / 60.0).setScale(2, 4).doubleValue());
            attendShift.setRestHour(BigDecimal.valueOf((double)restHourDiff.intValue() / 60.0).setScale(2, 4).doubleValue());
        } else {
            List checkList;
            attendShift.setNeedRest("0");
            ValidatorUtils.validateEntity((Object)((Object)attendShift), (Class[])new Class[]{TwoGroup.class});
            AttendShiftDto searchDto = new AttendShiftDto();
            searchDto.setStartTime(attendShift.getStartTime());
            searchDto.setShiftType(attendShift.getShiftType());
            searchDto.setComId(attendShift.getComId());
            searchDto.setDomainAdmin(true);
            searchDto.setAttendId(attendShift.getAttendId());
            List<AttendShiftDto> attendShiftDtos = this.attendShiftMapper.selectList(searchDto);
            if (attendShiftDtos.size() > 0 && (checkList = attendShiftDtos.stream().filter(shiftDto -> !shiftDto.getId().equals(attendShift.getId())).collect(Collectors.toList())).size() > 0) {
                throw new BusinessException("\u4e0a\u73ed\u65f6\u95f4\u4e0e\u73ed\u6b21\u3010" + ((AttendShiftDto)((Object)checkList.get(0))).getShiftName() + "\u3011\u7684\u4e0a\u73ed\u65f6\u95f4\u51b2\u7a81\uff01");
            }
        }
        AttendShift checkShift = this.attendShiftMapper.findByNameAndAttend(attendShift);
        if (checkShift != null && !checkShift.getId().equals(attendShift.getId())) {
            throw new BusinessException("\u73ed\u6b21\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
    }

    @Override
    public int update(AttendShift attendShift) {
        this.validateData(attendShift);
        if (attendShift.getId() == null) {
            attendShift.setCreateTime(DateUtils.getNowDate());
            attendShift.setId(this.idWorker.nextId());
            attendShift.setIsDelete("0");
        } else {
            List<AttendShift> attendShifts;
            AttendShift dbAttendShift = this.attendShiftMapper.findById(attendShift.getId());
            if (("0".equals(attendShift.getActive()) || !attendShift.getStartTime().equals(dbAttendShift.getStartTime()) || StrUtil.isEmpty((CharSequence)attendShift.getEndTime()) && StrUtil.isNotEmpty((CharSequence)attendShift.getEndTime()) || StrUtil.isNotEmpty((CharSequence)attendShift.getEndTime()) && !attendShift.getEndTime().equals(dbAttendShift.getEndTime())) && (attendShifts = this.attendShiftMapper.findUsedList(Convert.toStrArray((String)attendShift.getId().toString()))).size() > 0) {
                throw new BusinessException("\u3010" + attendShift.getShiftName() + "\u3011\u8be5\u73ed\u6b21\u5728\u4f7f\u7528\u4e2d\uff0c\u65e0\u6cd5\u4f5c\u5e9f\u6216\u8005\u4fee\u6539\u4e0a\u4e0b\u73ed\u65f6\u95f4\uff01");
            }
            BeanUtils.copyPropertiesIgnore((Object)((Object)attendShift), (Object)((Object)dbAttendShift), (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)((Object)dbAttendShift), (Object)((Object)attendShift), (Boolean)false);
        }
        if ("2".equals(attendShift.getShiftType())) {
            attendShift.setShiftHour(null);
            attendShift.setEndTime(null);
            attendShift.setNeedRest("0");
        }
        if ("0".equals(attendShift.getNeedRest())) {
            attendShift.setRestStart(null);
            attendShift.setRestEnd(null);
            attendShift.setRestHour(0.0);
        }
        attendShift.setUpdateTime(DateUtils.getNowDate());
        return this.attendShiftMapper.save(attendShift);
    }

    @Override
    public int deleteByIds(String ids) {
        List<AttendShift> attendShifts = this.attendShiftMapper.findByArrIds(Convert.toStrArray((String)ids));
        for (AttendShift attendShift : attendShifts) {
            if (!"1".equals(attendShift.getActive())) continue;
            throw new BusinessException("\u3010" + attendShift.getShiftName() + "\u3011\u8be5\u73ed\u6b21\u672a\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        attendShifts = this.attendShiftMapper.findUsedList(Convert.toStrArray((String)ids));
        Iterator<AttendShift> iterator = attendShifts.iterator();
        if (iterator.hasNext()) {
            AttendShift attendShift;
            attendShift = iterator.next();
            throw new BusinessException("\u3010" + attendShift.getShiftName() + "\u3011\u8be5\u73ed\u6b21\u5728\u4f7f\u7528\u4e2d\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        return this.attendShiftMapper.deleteByIds(Convert.toStrArray((String)ids));
    }
}

