/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendLeave;
import com.bcxin.platform.mapper.attend.AttendLeaveMapper;
import com.bcxin.platform.service.attend.AttendLeaveService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class AttendLeaveServiceImpl
implements AttendLeaveService {
    @Autowired
    private AttendLeaveMapper attendLeaveMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public AttendLeave findById(Long id) {
        return this.attendLeaveMapper.findById(id);
    }

    @Override
    public List<AttendLeave> selectList(AttendLeave attendLeave) {
        return this.attendLeaveMapper.selectList(attendLeave);
    }

    @Override
    public int update(AttendLeave attendLeave) {
        if (attendLeave.getId() == null) {
            attendLeave.setCreateTime(DateUtils.getNowDate());
            attendLeave.setId(this.idWorker.nextId());
        } else {
            AttendLeave dbAttendLeave = this.attendLeaveMapper.findById(attendLeave.getId());
            BeanUtils.copyPropertiesIgnore((Object)((Object)attendLeave), (Object)((Object)dbAttendLeave), (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)((Object)dbAttendLeave), (Object)((Object)attendLeave), (Boolean)false);
        }
        attendLeave.setUpdateTime(DateUtils.getNowDate());
        return this.attendLeaveMapper.save(attendLeave);
    }

    @Override
    public int deleteByIds(String ids) {
        return this.attendLeaveMapper.deleteByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public void saveBatch(List<AttendLeave> list) {
        int limit = 200;
        int count = new Double(Math.ceil((double)list.size() * 1.0 / (double)limit)).intValue();
        List<AttendLeave> subList = null;
        for (int i = 0; i < count; ++i) {
            subList = list.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
            List<AttendLeave> dbLidt = this.attendLeaveMapper.findByBatchOaLeaveId(subList);
            subList.removeAll(dbLidt);
            if (subList.size() <= 0) continue;
            this.attendLeaveMapper.saveBatch(subList);
        }
    }
}

