package com.bcxin.ars.timer.task.status;

import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.task.TaskService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AutoSendUrgentTaskService {
	
	private Logger logger = LoggerFactory.getLogger(AutoSendUrgentTaskService.class);
	
	@Autowired
	private TaskService taskService;
	
	@Autowired
	private TaskDao taskDao;
	
	@Autowired
	private SecurityPersonDao personDao;

	@Autowired
	private ConfigUtils configUtils;

	@Value("${timeFlag}")
	private String timeFlag = "";

	public void sendUrgentTask() {
		//查询  是否与saas对接 配置信息
		Config saasJoin = configUtils.getConfigByKey(Constants.SaaSJoin);
		if(saasJoin != null && Constants.SaaSJoin_YES.equals(saasJoin.getValue())){
			//与saas对接的，不执行定时器
			return;
		}

		Config config = configUtils.getConfigByKey("police");
		// 外网
		if (config.getValue().equals("0") && timeFlag.equals("true")) {
			logger.info("begin to update task status...");
			taskService.sendUrgentTask();
			logger.info("update task status done.");
		}
	}
	
}
