package com.bcxin.ars.timer.personcertificate;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

/**
 * @author linqinglin
 * @date 2020/07/23 0023 14:53
 */
@Service
public class SecurityCertificateToSaasService {


    private Logger logger = LoggerFactory.getLogger(SecurityCertificateToSaasService.class);

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private SecurityCertificateService securityCertificateService;

    @Autowired
    private SecurityCertificateDao securityCertificateDao;

    @Value("${timeFlag}")
    private String timeFlag = "";

    @Value("${BBD_H5_URL}")
    private String bbdH5Url;

    @Autowired
    private JobRunLogService jobRunLogService;


    private boolean lock = false;

    public void sendToSaas(){

        if(lock){
            return;
        }
        lock = true;

        try {
            if(!configUtils.isIntranet() && timeFlag.equals("true")){
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                try{
                    List<SecurityCertificate> list = securityCertificateDao.findUnPushToSAAS();

                    if(list.size() > 0) {

                        List<SecurityCertificate> saveList = new Vector<>();
                        //使用线程池
                        CountDownLatch workCount = ThreadUtil.newCountDownLatch(list.size());
                        ExecutorService threadPoolExecutor = ThreadUtil.newExecutor(15, 15,2000);

                        for (SecurityCertificate securityCertificate : list) {
                            threadPoolExecutor.execute(new Runnable() {
                                @Override
                                public void run() {
                                    try {
                                        if (securityCertificate.getSnapshotId() == null) {
                                            String photo = "";
                                            if(StringUtil.isNotEmpty(securityCertificate.getHeadImg())){
                                                photo = securityCertificate.getHeadImg();
                                            }else{
                                                photo = securityCertificateService.getPhotoUrl(securityCertificate);
                                            }
                                            securityCertificateService.savePerCerSnapshot(securityCertificate, photo);
                                            securityCertificate.setUpdateTime(new Date());
                                            securityCertificate.setUpdateflag(true);
                                            securityCertificateDao.update(securityCertificate);
                                        }
                                        AjaxResult result = securityCertificateService.updateSecurityPersonCertificateInfo(securityCertificate);

                                        if (result.isSuccessful()) {
                                            saveList.add(securityCertificate);
                                        }
                                    } catch (Exception e) {
                                        logger.error(e.getMessage(), e);
                                        e.printStackTrace();
                                    } finally {
                                        workCount.countDown();
                                    }
                                }
                            });
                        }

                        try {
                            //线程等待全部数据文件生成完成
                            workCount.await();
                        } catch (InterruptedException e) {
                            logger.error(e.getMessage(), e);
                            Thread.currentThread().interrupt();
                        }finally {
                            threadPoolExecutor.shutdown();
                        }

                        if(saveList.size() > 0) {
                            securityCertificateDao.batchUpdatePushState(saveList);
                        }
                    }

                }catch (Exception e ){
                    //异常信息存储
                    e.printStackTrace();
                    logger.error(e.getMessage(),e);
                    log.setExceptionMsg(e.getMessage());
                }
                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(SecurityCertificateToSaasService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }finally {
            lock = false;
        }
    }
}
