package com.bcxin.ars.timer.person;

import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.task.ComTaskPerDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.timer.problemPerson.ProblemPersonCriminalServiceJob;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;

/***
 * 定时更新公司人员数量和投保人数
 */
@Service
public class UpdateCompanyPerNumService {

    /***
     * 日志
     */
    private static  final  Logger logger = LoggerFactory.getLogger(UpdateCompanyPerNumService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;
    @Autowired
    private ComTaskPerDao comTaskPerDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Value("${timeFlag}")
    private String timeFlag = "";
    public void run() {
        //判断是否为公安外网
        Config config = configUtils.getConfigByKey(Constants.POLICE);
        if(Constants.POLICE_OUT.equals(config.getValue()) && timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(true);
            log.setUpdateBy("jobSystem");
            //开始时间
            long startTime = System.currentTimeMillis();
            try {
                //定时更新人员数量
                securityCompanyDao.updateNumberByTime();
            }catch (Exception e){
                logger.error(e.getMessage(),e);
                log.setExceptionMsg(e.toString());
            }
            //日志信息
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(UpdateCompanyPerNumService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength((endTime - startTime) + "ms");
            jobRunLogService.insert(log);
        }
    }
}
