package com.bcxin.ars.timer.dataSync;

import com.bcxin.ars.dao.datasync.DataSyncLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.datasync.DataSyncDto;
import com.bcxin.ars.model.datasync.DataSyncLog;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncInterfaceUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author linqinglin
 * @date 2020/12/07 0007 14:53
 */
@Service
public class DataSyncToFtpService {
    /***
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(DataSyncToFtpService.class);

    @Autowired
    private DataSyncLogDao dataSyncLogDao;

    @Autowired
    private JobRunLogService jobRunLogService;

    @Autowired
    private DataSyncInterfaceUtil dataSyncInterfaceUtil;

    @Autowired
    private ConfigUtils configUtils;


    private boolean lock = false;
    public void run() {
        if(lock){
            return;
        }
        lock = true;

        try {
            if (Constants.TIMEFLAG_VALUE.equals(configUtils.timeFlag)) {

                if(!Constants.DATASYNC_SWITCH_1.equals(configUtils.getValueByKey(Constants.DATASYNC_SWITCH))){
                    return;
                }
                if(!Constants.YES.equals(configUtils.getValueByKey(Constants.DATASYNC_INTERFACE_SWITCH))){
                    return;
                }

                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                try {
                    List<DataSyncLog> dataSyncLogList = dataSyncLogDao.findUnDataSyncList();
                    if(dataSyncLogList.size() > 0){
                        DataSyncDto dataSyncDto = null;
                        AjaxResult result = null;

                        List<DataSyncLog> saveList = new ArrayList<>();
                        for (DataSyncLog dataSyncLog : dataSyncLogList) {
                            try {
                                result = dataSyncInterfaceUtil.callInterface(Constants.DATASYNC_FTP_URL, dataSyncLog);
                                if(result.isSuccessful()){
                                    dataSyncLog.setMsgId(result.getData().toString());
                                    dataSyncLog.setDataSyncState(Constants.DATASYNCSTATE_1);
                                    dataSyncLog.setErrorInfo(StringUtil.EMPTY);
                                }else{
                                    dataSyncLog.setErrorInfo(result.getMsg());
                                    if(dataSyncLog.getErrorInfo().length()>400) {
                                        dataSyncLog.setErrorInfo(dataSyncLog.getErrorInfo().substring(0, 400));
                                    }
                                }

                                dataSyncLog.setUpdateTime(new Date());
                                dataSyncLog.setUpdateflag(true);

                                saveList.add(dataSyncLog);
                            }catch (Exception e){
                                e.printStackTrace();
                            }
                        }
                        if(saveList.size() >0) {
                            dataSyncLogDao.saveBatch(saveList);
                        }
                    }


                }catch (Exception e){
                    logger.error(e.getMessage(),e);
                    log.setExceptionMsg(e.toString());
                }
                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(DataSyncToFtpService.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        }finally {
            lock = false;
        }
    }
}
