/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.police;

import cn.hutool.core.thread.ThreadUtil;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.spring.util.SpringUtils;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.police.SecurityInterfaceService;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProblemPersonJob {
    private Logger logger = LoggerFactory.getLogger(ProblemPersonJob.class);
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private ConfigUtils configUtils;
    private static BackGroupCensorService backGroupCensorService;
    @Value(value="${ZAFLAG}")
    private String ZAFLAG;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JobLogAnnotation(getJobClazz=ProblemPersonJob.class)
    public void run() {
        block13: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                if (!"61".equals(this.configUtils.getCurrentNative())) {
                    return;
                }
                if (!this.configUtils.isIntranet() || this.ZAFLAG == null || !"1".equals(this.ZAFLAG)) break block13;
                try {
                    List personList;
                    if (backGroupCensorService == null) {
                        backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
                    }
                    if ((personList = this.securityPersonService.findUnCensor()).size() <= 0) break block13;
                    SecurityInterfaceService securityInterfaceService = (SecurityInterfaceService)SpringUtils.getBean((String)("securityInterfaceService_" + this.configUtils.getCurrentProvince()));
                    int limit = 5;
                    int count = new Double(Math.ceil((double)personList.size() * 1.0 / (double)limit)).intValue();
                    List subList = null;
                    for (int i = 0; i < count; ++i) {
                        subList = personList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                        securityInterfaceService.censorNewPerson(subList);
                        final CopyOnWriteArrayList successPersonList = new CopyOnWriteArrayList();
                        final CountDownLatch countDownLatch1 = ThreadUtil.newCountDownLatch((int)subList.size());
                        ThreadPoolExecutor threadPoolExecutor1 = ThreadUtil.newExecutor((int)30, (int)30);
                        for (final SecurityPerson securityPerson : subList) {
                            threadPoolExecutor1.execute(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        Boolean result = false;
                                        if (securityPerson.getBackgroundApprovals() != null && securityPerson.getBackgroundApprovals().size() > 0) {
                                            for (BackgroundApproval backgroundApproval : securityPerson.getBackgroundApprovals()) {
                                                if (!"004".equals(backgroundApproval.getApprovalstate())) continue;
                                                result = true;
                                            }
                                        }
                                        if (!securityPerson.getCensorStatusError().booleanValue()) {
                                            if (result.booleanValue()) {
                                                backGroupCensorService.censorSaveProblemPerson(securityPerson, securityPerson.getBackgroundApprovals());
                                            } else {
                                                successPersonList.add(securityPerson);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        ProblemPersonJob.this.logger.error(e.getMessage(), (Throwable)e);
                                        e.printStackTrace();
                                    }
                                    finally {
                                        countDownLatch1.countDown();
                                    }
                                }
                            });
                        }
                        try {
                            countDownLatch1.await();
                        }
                        catch (InterruptedException e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                        }
                        threadPoolExecutor1.shutdown();
                        if (successPersonList == null || successPersonList.size() <= 0) continue;
                        this.securityPersonService.updateCensorStatusList(successPersonList);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
            finally {
                this.lock = false;
            }
        }
    }
}

