/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.dao.FilerecordDao;
import com.bcxin.ars.dao.FilerecordOutDao;
import com.bcxin.ars.dao.FilerecordStatusDao;
import com.bcxin.ars.dao.SyncFailLogDao;
import com.bcxin.ars.dao.sys.SyncDataDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Filerecord;
import com.bcxin.ars.model.FilerecordOut;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ConfigSyncData;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.CyFirearmsLogService;
import com.bcxin.ars.service.CyServerhtService;
import com.bcxin.ars.service.DatasyncService;
import com.bcxin.ars.service.OrderPersonService;
import com.bcxin.ars.service.OrderService;
import com.bcxin.ars.service.OrderTransactionService;
import com.bcxin.ars.service.OrganizationService;
import com.bcxin.ars.service.PoliceRoleService;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.RoleService;
import com.bcxin.ars.service.SbBusinessManagementService;
import com.bcxin.ars.service.SbBusinessOutsideManagementService;
import com.bcxin.ars.service.SbPunishService;
import com.bcxin.ars.service.SbRewardService;
import com.bcxin.ars.service.SbSubsidiaryBaseService;
import com.bcxin.ars.service.SbSubsidiaryManagerService;
import com.bcxin.ars.service.SecurityCompanyInsuranceService;
import com.bcxin.ars.service.SecurityCompanyPersonService;
import com.bcxin.ars.service.SecurityCompanyScheduleService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityGoodThingService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.exam.TrainExamInfoService;
import com.bcxin.ars.service.exam.TrainExamPersonService;
import com.bcxin.ars.service.msg.NewsCompanyRelationshipService;
import com.bcxin.ars.service.msg.NewsnoticeCompanyService;
import com.bcxin.ars.service.msg.NewsnoticePoliceService;
import com.bcxin.ars.service.msg.NewsnoticeRecipientService;
import com.bcxin.ars.service.msg.SysAttachmentService;
import com.bcxin.ars.service.sb.ArmorgchargeService;
import com.bcxin.ars.service.sb.ArmorgteachService;
import com.bcxin.ars.service.sb.ArmtrainchargeService;
import com.bcxin.ars.service.sb.ArmtrainorgService;
import com.bcxin.ars.service.sb.ConfesscompanyService;
import com.bcxin.ars.service.sb.ConfesscompanyundoService;
import com.bcxin.ars.service.sb.CrosscompanyService;
import com.bcxin.ars.service.sb.FamilyService;
import com.bcxin.ars.service.sb.FirearmsService;
import com.bcxin.ars.service.sb.InvestorService;
import com.bcxin.ars.service.sb.LegalchangeService;
import com.bcxin.ars.service.sb.LegalchangeworkexperienceService;
import com.bcxin.ars.service.sb.ManagementInfoService;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.sb.PersonworkexperienceService;
import com.bcxin.ars.service.sb.SafetyService;
import com.bcxin.ars.service.sb.SbSponsorlicenseManagerService;
import com.bcxin.ars.service.sb.SbSponsorlicenseVmanagerService;
import com.bcxin.ars.service.sb.ShareholderService;
import com.bcxin.ars.service.sb.SponsorlicenseService;
import com.bcxin.ars.service.sb.SubsidiaryService;
import com.bcxin.ars.service.sb.SubsidiarypersonService;
import com.bcxin.ars.service.sb.TraincompanyapplyService;
import com.bcxin.ars.service.sb.VehicleLogService;
import com.bcxin.ars.service.sb.VehicleService;
import com.bcxin.ars.service.sb.WorkexperienceService;
import com.bcxin.ars.service.sb.YearReportInsuranceService;
import com.bcxin.ars.service.sb.YearReportInvestorService;
import com.bcxin.ars.service.sb.YearreportdataManagerService;
import com.bcxin.ars.service.sb.YearreportdataService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.sys.SyncDataService;
import com.bcxin.ars.service.task.TaskFeedbackService;
import com.bcxin.ars.service.task.TaskPersonScheduleDetailService;
import com.bcxin.ars.service.task.TaskPersonScheduleService;
import com.bcxin.ars.service.task.TaskPersonService;
import com.bcxin.ars.service.task.TaskScheduleService;
import com.bcxin.ars.service.task.TaskService;
import com.bcxin.ars.service.task.TeamPersonService;
import com.bcxin.ars.service.task.UrgentTeamService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.CipherDESUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.EmailUtils;
import com.bcxin.ars.util.Encodes;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.ClientUtil;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.crypto.BadPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class Data2SynchronizationService {
    private Logger logger = LoggerFactory.getLogger(Data2SynchronizationService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private TaskService taskService;
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private SecurityCertificateService securityCertificateService;
    @Autowired
    private SyncDataDao syncDataDao;
    @Autowired
    private SyncFailLogDao syncFailLogDao;
    @Autowired
    private ConfigService configService;
    @Autowired
    private SecurityCompanyPersonService securityCompanyPersonService;
    @Autowired
    private UserService userService;
    @Autowired
    private PoliceService policeService;
    @Autowired
    private PoliceRoleService policeRoleService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private SecurityCompanyService securityCompanyService;
    @Autowired
    private SecurityCompanyScheduleService securityCompanyScheduleService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private ApprovalService approvalService;
    @Autowired
    private ConfesscompanyService confesscompanyService;
    @Autowired
    private CrosscompanyService crosscompanyService;
    @Autowired
    private LegalchangeService legalchangeService;
    @Autowired
    private LegalchangeworkexperienceService legalchangeworkexperienceService;
    @Autowired
    private WorkexperienceService workexperienceService;
    @Autowired
    private YearreportdataService yearreportDataService;
    @Autowired
    private SecurityCompanyInsuranceService securityCompanyInsuranceService;
    @Autowired
    private YearreportdataManagerService yearreportdataManagerService;
    @Autowired
    private YearReportInsuranceService yearReportInsuranceService;
    @Autowired
    private YearReportInvestorService yearReportInvestorService;
    @Autowired
    private PersoncertificateService personcertificateService;
    @Autowired
    private FamilyService familyService;
    @Autowired
    private PersonworkexperienceService personworkexperienceService;
    @Autowired
    private SponsorlicenseService sponsorlicenseService;
    @Autowired
    private ShareholderService shareholderService;
    @Autowired
    private SubsidiaryService subsidiaryService;
    @Autowired
    private SubsidiarypersonService subsidiarypersonService;
    @Autowired
    private TraincompanyapplyService traincompanyapplyService;
    @Autowired
    private UrgentTeamService urgentTeamService;
    @Autowired
    private TeamPersonService teamPersonService;
    @Autowired
    private TaskPersonService taskPersonService;
    @Autowired
    private TaskPersonScheduleService taskPersonScheduleService;
    @Autowired
    private TaskPersonScheduleDetailService taskPersonScheduleDetailService;
    @Autowired
    private TaskScheduleService taskScheduleService;
    @Autowired
    private TaskFeedbackService taskFeedbackService;
    @Autowired
    private DatasyncService datasyncService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderPersonService orderPersonService;
    @Autowired
    private OrderTransactionService orderTransactionService;
    @Autowired
    private SbSubsidiaryBaseService sbSubsidiaryBaseService;
    @Autowired
    private SbSubsidiaryManagerService sbSubsidiaryManagerService;
    @Autowired
    private SbBusinessManagementService sbBusinessManagementService;
    @Autowired
    private SbBusinessOutsideManagementService sbBusinessOutsideManagementService;
    @Autowired
    private SbRewardService sbRewardService;
    @Autowired
    private SbPunishService sbPunishService;
    @Autowired
    private SecurityGoodThingService securityGoodThingService;
    @Autowired
    private VehicleService vehicleService;
    @Autowired
    private VehicleLogService vehicleLogService;
    @Autowired
    private FirearmsService firearmsService;
    @Autowired
    private CyFirearmsLogService cyFirearmsLogService;
    @Autowired
    private SafetyService safetyService;
    @Autowired
    private InvestorService investorService;
    @Autowired
    private ManagementInfoService managementInfoService;
    @Autowired
    private CyServerhtService cyServerhtService;
    @Autowired
    private FilerecordDao filerecordDao;
    @Autowired
    private FilerecordOutDao filerecordOutDao;
    @Autowired
    private FilerecordStatusDao filerecordStatusDao;
    @Autowired
    private ClientUtil clientUtil;
    @Autowired
    private ArmtrainorgService armtrainorgService;
    @Autowired
    private ArmorgteachService armorgteachService;
    @Autowired
    private ArmorgchargeService armorgchargeService;
    @Autowired
    private ArmtrainchargeService armtrainchargeService;
    @Autowired
    private ConfesscompanyundoService confesscompanyundoService;
    @Autowired
    private NewsnoticeCompanyService newsnoticeCompanyService;
    @Autowired
    private NewsnoticePoliceService newsnoticePoliceService;
    @Autowired
    private NewsCompanyRelationshipService newsCompanyRelationshipService;
    @Autowired
    private NewsnoticeRecipientService newsnoticeRecipientService;
    @Autowired
    private SysAttachmentService sysAttachmentService;
    @Autowired
    private SyncDataService syncDataService;
    @Autowired
    private SbSponsorlicenseManagerService sbSponsorlicenseManagerService;
    @Autowired
    private SbSponsorlicenseVmanagerService sbSponsorlicenseVmanagerService;
    @Autowired
    private TrainExamInfoService trainExamInfoService;
    @Autowired
    private TrainExamPersonService trainExamPersonService;
    @Value(value="${ftp-folder}")
    private String ftpFolder;
    @Value(value="${ftp-temp-folder}")
    private String tempftpFolder;
    @Value(value="${timeFlag}")
    private String timeFlag = "";

    public List<Date> getBetweenDates(Date start, Date end) {
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        tempStart.add(6, 1);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd)) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
        }
        return result;
    }

    public void run() {
        block21: {
            String nowStr;
            block23: {
                Config datasynchronizationconfig = this.configUtils.getConfigByKey("datasynchronization");
                if (datasynchronizationconfig == null || !"1".equals(datasynchronizationconfig.getValue()) || !"true".equals(this.timeFlag)) break block21;
                Config config = this.configUtils.getConfigByKey("police");
                nowStr = DateUtil.getCurrentDate();
                if (config == null || !"1".equals(config.getValue())) break block23;
                Config lastDateConfig = this.configUtils.getConfigByKey("lastDate");
                if (lastDateConfig == null) break block21;
                String lastDate = lastDateConfig.getValue();
                List<Date> dates = this.getBetweenDates(DateUtil.convertStringToDate((String)lastDate), DateUtil.convertStringToDate((String)nowStr));
                dates.add(DateUtil.convertStringToDate((String)nowStr));
                for (Date d : dates) {
                    String filePath = this.ftpFolder + DateUtil.convertDateToString((Date)d, (String)"yyyy-MM-dd");
                    File f = new File(filePath);
                    if (!f.exists()) break block21;
                    boolean errorFlag = false;
                    String[] filenames = new String[]{"police", "policeRole", "user", "company", "organization", "role", "person", "securityCompanySchedule", "task", "taskFeedback", "crosscompany", "confesscompany", "traincompanyapply", "workexperience", "legalchange", "legalchangeworkexperience", "yearreport", "securityCompanyInsurance", "yearreportdataManager", "yearReportInsurance", "yearReportInvestor", "armtrainorg", "armorgteach", "armorgcharge", "armtraincharge", "personcertificate", "family", "personworkexperience", "subsidiary", "subsidiaryperson", "sponsorlicense", "sbsponsorlicenseManager", "sbsponsorlicenseVManager", "sponsorlicense", "confesscompanyundo", "securitycertificate", "shareholder", "approval", "datasync", "order", "orderPerson", "orderTransaction", "sbSubsidiaryBase", "sbSubsidiaryManager", "sbBusinessManagement", "sbBusinessOutsideManagement", "sbReward", "sbPunish", "securityGoodThing", "vehicle", "vehicleLog", "firearms", "cyFirearmsLog", "safety", "investor", "managementInfo", "cyServerht", "newsnoticePolice", "newsnoticeCompany", "newsCompanyRelationship", "sysAttachment", "newsnoticeRecipient", "trainExamInfo", "trainExamPerson"};
                    LinkedHashMap fileNameMap = new LinkedHashMap();
                    File[] fa = f.listFiles();
                    for (int i = 0; i < fa.length; ++i) {
                        block22: {
                            File fs2 = fa[i];
                            String[] splitFiles = fs2.getName().replace(".data", "").split("_");
                            if (splitFiles.length != 2) continue;
                            List<String> list = Arrays.asList(filenames);
                            if (list.contains(splitFiles[0])) {
                                String filename = splitFiles[0];
                                String createTime = splitFiles[1];
                                if (StringUtil.isEmpty((String)createTime)) continue;
                                File fs = new File(filePath + "/" + filename + "_" + createTime + ".data");
                                if (fs.exists() && fs.isFile()) {
                                    try {
                                        this.logger.info(filePath + "/" + filename + "_" + createTime + ".data");
                                        BufferedReader br = new BufferedReader(new FileReader(fs));
                                        StringBuffer content = new StringBuffer();
                                        String lineTxt = null;
                                        while ((lineTxt = br.readLine()) != null) {
                                            content.append(lineTxt);
                                        }
                                        br.close();
                                        String jsonStr = new String(CipherDESUtil.decrypt((byte[])Encodes.decodeHex((String)content.toString()), (String)Constants.APPROVAL_KEY));
                                        if (fs.getName().equals("approval_" + createTime + ".data")) {
                                            List approvalList;
                                            Filerecord dbfilerecord = this.isFilerecord(fs.getAbsolutePath());
                                            if (dbfilerecord == null && (approvalList = JSONArray.parseArray((String)jsonStr, Approval.class)) != null && approvalList.size() > 0) {
                                                for (Approval approval : approvalList) {
                                                    try {
                                                        this.approvalService.saveOrUpdateForDS(approval);
                                                    }
                                                    catch (Exception e) {
                                                        this.logger.error(e.getMessage(), (Throwable)e);
                                                        e.printStackTrace();
                                                    }
                                                }
                                                this.saveFielrecord(fs.getAbsolutePath(), fs.getName(), approvalList.size());
                                            }
                                        } else {
                                            this.syncDataService.syncDataByJava(jsonStr, fs);
                                        }
                                        break block22;
                                    }
                                    catch (BadPaddingException badPaddingException) {
                                        this.logger.error("\u8bfb\u53d6(" + fs.getName() + ")\u6587\u4ef6\u5185\u5bb9\u51fa\u9519,\u975e\u8be5\u533a\u57df\u6587\u4ef6");
                                        this.logger.error(fs.getName());
                                        badPaddingException.printStackTrace();
                                        this.logger.error(badPaddingException.getMessage());
                                        errorFlag = true;
                                        continue;
                                    }
                                    catch (Exception e) {
                                        this.logger.error("\u8bfb\u53d6(" + fs.getName() + ")\u6587\u4ef6\u5185\u5bb9\u51fa\u9519");
                                        this.logger.error(fs.getName());
                                        e.printStackTrace();
                                        this.logger.error(e.getMessage(), (Throwable)e);
                                        errorFlag = true;
                                        continue;
                                    }
                                }
                                System.out.println("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\uff08" + fs.getName() + "\uff09\u6587\u4ef6");
                            }
                        }
                        if (errorFlag) continue;
                        Config updateConfig = new Config();
                        updateConfig.setKey("lastDate");
                        updateConfig.setValue(DateUtil.convertDateToString((Date)d, (String)"yyyy-MM-dd"));
                        this.configUtils.updateForKey(updateConfig);
                    }
                }
                break block21;
            }
            DataSynchronizationSearchDto searchDto = new DataSynchronizationSearchDto();
            searchDto.setPaging(false);
            Config startDateConfig = this.configService.findByKey("SYNC_READ_STARTTIME");
            Config offsetConfig = this.configService.findByKey("OFFSET_TIME");
            try {
                searchDto.setStartDate(DateUtil.convertDateToString((Date)DateUtil.dateAdd2((int)5, (Date)DateUtil.convertStringToDate((String)startDateConfig.getValue()), (int)(offsetConfig.getValue() == null ? 0 : Integer.parseInt(offsetConfig.getValue()) * -1)), (String)"yyyy-MM-dd HH:mm:ss"));
                searchDto.setEndDate(DateUtil.getTomorrow());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List approvalList = this.approvalService.searchForDataSynchronization(searchDto);
            if (approvalList != null && approvalList.size() > 0) {
                try {
                    String approvalListStr = JSONArray.toJSONString((Object)approvalList);
                    String content = CipherDESUtil.parseByte2HexStr((byte[])CipherDESUtil.encrypt((byte[])approvalListStr.getBytes(), (String)Constants.APPROVAL_KEY));
                    this.writeTxtFile(content, "approval");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.createDataSyncFile(DateUtil.getTomorrow(), DateUtil.getYesterday());
            try {
                Data2SynchronizationService.copyDir(this.tempftpFolder + nowStr, this.ftpFolder + nowStr);
                startDateConfig.setValue(DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.configService.update(startDateConfig);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void createDataSyncFile(String syncStartDate, String syncEndDate) {
        long startTime = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)syncStartDate)) {
            syncStartDate = DateUtil.getYesterday();
        }
        List configList = this.syncDataDao.getConfigSyncDataList();
        ArrayList filePathList = new ArrayList();
        Config police = this.configService.findByKey("police");
        Config syncDataNotifier = new Config();
        Config currentEnvi = new Config();
        if (police != null && police.getValue().equals("0")) {
            syncDataNotifier = this.configService.findByKey("syncDataNotifier");
            currentEnvi = this.configService.findByKey("current_native_name");
        }
        EmailUtils email = new EmailUtils();
        String currentEnviName = currentEnvi.getValue() == null ? "" : currentEnvi.getValue();
        for (ConfigSyncData config : configList) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("sql", "SELECT * FROM `" + config.getTableName() + "` limit 100");
            List dataList = this.syncDataDao.executeSelectSql(param);
            if (dataList == null || dataList.size() <= 0) continue;
            try {
                String dataJsonStr = JSONArray.toJSONString((Object)dataList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
                String content = CipherDESUtil.parseByte2HexStr((byte[])CipherDESUtil.encrypt((byte[])dataJsonStr.getBytes(), (String)Constants.APPROVAL_KEY));
                this.writeTxtFile(content, config.getFileName());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (police == null || !police.getValue().equals("0") || syncDataNotifier == null || syncDataNotifier.getValue() == null) continue;
                email.sendEmail("\u767e\u4fdd\u76fe\u5916\u7f51\u751f\u6210\u6570\u636e\u6587\u4ef6\u51fa\u9519", "\u540c\u6b65\u73af\u5883:\u3010" + currentEnviName + "\u5916\u7f51\u3011\n\u6587\u4ef6\u540d:\u3010" + config.getFileName() + ".data\u3011\n\u5f02\u5e38\u4fe1\u606f:\u3010" + e.getMessage().toString() + "\u3011", syncDataNotifier.getValue());
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("\u5f53\u524d\u7a0b\u5e8f\u8017\u65f6\uff1a" + (endTime - startTime) + "ms");
    }

    private void writeTxtFile(String readStr, String type) {
        try {
            String basePath = this.tempftpFolder;
            String filePath = basePath + DateUtil.getCurrentDate() + File.separator;
            String fileName = type;
            String fileType = ".data";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                System.out.println("\u6587\u4ef6\u5939\u5df2\u521b\u5efa");
            }
            String fullFilePath = filePath + fileName + "_" + DateUtil.getCurrentDateTime((String)"yyyyMMddHHmmss") + fileType;
            this.saveFielrecordOut(fullFilePath, fileName + "_" + DateUtil.getCurrentDateTime((String)"yyyyMMddHHmmss") + fileType);
            File newFile = new File(fullFilePath);
            Files.write((byte[])readStr.getBytes(), (File)newFile);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void copyDir(String oldPath, String newPath) throws IOException {
        File file = new File(oldPath);
        String[] filePath = file.list();
        if (!new File(newPath).exists()) {
            new File(newPath).mkdir();
        }
        if (filePath == null) {
            return;
        }
        for (int i = 0; i < filePath.length; ++i) {
            if (new File(oldPath + File.separator + filePath[i]).isDirectory()) {
                Data2SynchronizationService.copyDir(oldPath + File.separator + filePath[i], newPath + File.separator + filePath[i]);
            }
            if (!new File(oldPath + File.separator + filePath[i]).isFile()) continue;
            File from = new File(oldPath + File.separator + filePath[i]);
            File to = new File(newPath + File.separator + filePath[i]);
            if (to.exists()) continue;
            Files.copy((File)from, (File)to);
        }
    }

    public Filerecord isFilerecord(String filename) {
        Filerecord dbfilerecord = this.filerecordDao.findByFilepath(filename);
        if (dbfilerecord == null) {
            System.out.println("\u5f00\u59cb\u8bfb\u53d6\u6587\u4ef6\uff1a" + filename);
        }
        return dbfilerecord;
    }

    public void saveFielrecord(String filepath, String filename, Integer recordsize) {
        Filerecord filerecord = new Filerecord();
        filerecord.setFilepath(filepath);
        filerecord.setFilename(filename);
        filerecord.setCreateTime(new Date());
        filerecord.setSynchtype(filename.substring(0, filename.indexOf("_")));
        filerecord.setUpdateTime(filerecord.getCreateTime());
        filerecord.setRecordsize(recordsize);
        this.filerecordDao.save(filerecord);
        System.out.println("\u8bfb\u53d6\u6587\u4ef6\u5b8c\u6210\uff1a" + filename);
    }

    public void saveFielrecordOut(String filepath, String filename) {
        FilerecordOut filerecordOut = new FilerecordOut();
        filerecordOut.setFilepath(filepath);
        filerecordOut.setFilename(filename);
        filerecordOut.setSynchtype(filename.substring(0, filename.indexOf("_")));
        filerecordOut.setCreateTime(new Date());
        filerecordOut.setUpdateTime(filerecordOut.getCreateTime());
        this.filerecordOutDao.save(filerecordOut);
        System.out.println("\u5199\u5165\u6587\u4ef6\u5b8c\u6210\uff1a" + filename);
    }
}

