package com.bcxin.runtime.domain.syncs.enums;


import com.bcxin.saas.core.EnumValue;

public enum SyncProcessStatus implements EnumValue {
    Initialize(0, "初始化"),
    Processing(1, "处理中"),
    Done(2, "完成"),
    Error(3, "错误"),

    Retrying(4, "重试中"),
    SyncViaFTP(5,"对接摆渡服务"),
    DoneViaFTP(6,"对接摆渡服务"),
    ErrorViaFTP(7,"对接摆渡服务"),
    ErrorConfig(8,"无同步配置信息"),
    ErrorFromCallback(9,"来自回调的错误状态"),
    DoneFromCallback(10,"来自回调的成功状态");;

    private final int value;
    private final String desc;

    SyncProcessStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
