package com.bcxin.runtime.domain.syncs.commands;

import lombok.Getter;

import java.util.Collection;
import java.util.Map;

@Getter
public class CreateFtpDataSyncCommand extends CreateDataSyncCommand {
    private final String businessType;
    private final String filePaths;

    public CreateFtpDataSyncCommand(Collection<DataSet> dataSets, String businessType, String filePaths,
                                    Map<String, String> urlFilePathMappings) {
        super(dataSets, filePaths,urlFilePathMappings);

        this.businessType = businessType;
        this.filePaths = filePaths;
    }

    public static CreateFtpDataSyncCommand create(Collection<DataSet> dataSets, String businessType, String filePaths,Map<String, String> urlFilePathMappings) {
        return new CreateFtpDataSyncCommand(dataSets, businessType, filePaths, urlFilePathMappings);
    }

}
