package com.bcxin.runtime.domain.metas.entities;

import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "meta_settings")
public class SettingMetaEntity extends EntityBase<String> implements IAggregate {
    @Id
    private String id;

    @Column(name = "category", length = 500)
    private String category;

    @Column(name = "key", length = 500)
    private String key;

    @Column(name = "value", length = 5000)
    private String value;
}
