package com.bcxin.runtime.domain.metas.commands;

import com.bcxin.runtime.domain.metas.entities.enums.StartupType;
import lombok.Getter;
import java.util.Collection;

@Getter
public class RefreshTaskCommand {
    private final Collection<Task> tasks;

    public RefreshTaskCommand(Collection<Task> tasks) {
        this.tasks = tasks;
    }

    @Getter
    public static class Task {
        private final String id;
        private final String name;
        private final String desc;
        private final String path;
        private final String appId;
        private final TaskScriptConfig config;

        public Task(String appId, String id, String name, String desc, String path,
                    TaskScriptConfig config) {
            this.id = id;
            this.name = name;
            this.desc = desc;
            this.path = path;
            this.appId = appId;
            this.config = config;
        }

        public static Task create(String appId, String id, String name, String desc,
                                  String path, TaskScriptConfig config) {
            return new Task(appId, id, name, desc, path, config);
        }
    }

    @Getter
    public static class TaskScriptConfig {
        private final String terminate;
        private final String content;
        private final int period;
        private final StartupType startupType;

        public TaskScriptConfig(StartupType startupType, int period, String terminate, String content) {
            this.terminate = terminate;
            this.content = content;
            this.period = period;
            this.startupType = startupType;
        }

        public static TaskScriptConfig create(StartupType startupType, int period, String terminate, String content) {
            return new TaskScriptConfig(startupType, period, terminate, content);
        }
    }

    public static RefreshTaskCommand create(Collection<Task> tasks) {
        return new RefreshTaskCommand(tasks);
    }
}
