package com.bcxin.runtime.domain.metas.commands;
import com.bcxin.runtime.domain.snapshoots.FormSyncConfigSnapshot;
import lombok.Getter;

import java.util.Collection;

@Getter
public class CreateFormSyncMetaCommand {
    private final Collection<FormSync> formSyncs;

    public CreateFormSyncMetaCommand(Collection<FormSync> formSyncs) {
        this.formSyncs = formSyncs;
    }

    public static CreateFormSyncMetaCommand create(Collection<FormSync> formSyncs) {
        return new CreateFormSyncMetaCommand(formSyncs);
    }

    @Getter
    public static class FormSync {
        private final String appId;
        private final String formId;
        private final String note;
        private final String targetId;
        public final boolean isOnline;
        private final FormSyncConfigSnapshot config;

        public FormSync(String appId, String formId,FormSyncConfigSnapshot config,
                        boolean isOnline,
                        String note,String targetId) {
            this.appId = appId;
            this.formId = formId;
            this.note = note;
            this.targetId = targetId;
            this.isOnline = isOnline;
            this.config = config;
        }

        public static FormSync create(String appId, String formId,
                                      FormSyncConfigSnapshot config, boolean isOnline, String note, String targetId) {
            return new FormSync(appId, formId, config, isOnline, note, targetId);
        }
    }
}
