package com.bcxin.runtime.domain.messages.services.impls;

import com.bcxin.runtime.domain.messages.commands.BatchCreateMessageCommand;
import com.bcxin.runtime.domain.messages.commands.CreateMessageCommand;
import com.bcxin.runtime.domain.messages.entities.MessageEntity;
import com.bcxin.runtime.domain.messages.repositories.MessageRepository;
import com.bcxin.runtime.domain.messages.services.MessageService;
import com.bcxin.saas.core.components.JsonProvider;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

public class MessageServiceImpl implements MessageService {
    private final MessageRepository messageRepository;
    private final JsonProvider jsonProvider;

    public MessageServiceImpl(MessageRepository messageRepository,
                              JsonProvider jsonProvider) {
        this.messageRepository = messageRepository;
        this.jsonProvider = jsonProvider;
    }

    @Override
    public void dispatch(CreateMessageCommand command) {
        this.dispatch(BatchCreateMessageCommand.create(Collections.singleton(command)));
    }

    @Override
    public void dispatch(BatchCreateMessageCommand command) {
        Collection<MessageEntity> messageEntities =
                command.getItems().stream().map(mp -> {
                    MessageEntity messageEntity =
                            MessageEntity.create(
                                    mp.getSenderId(),
                                    mp.getMessageType(),
                                    mp.getTitle(),
                                    mp.getContent(),
                                    mp.getReceiverType(),
                                    mp.getReceiver(),
                                    mp.getParameter(),
                                    mp.getUniqueId(),
                                    this.jsonProvider
                            );

                    if (StringUtils.length(mp.getBusinessNumber()) > 0) {
                        messageEntity.assignBusinessNumber(mp.getBusinessNumber());
                    }

                    return messageEntity;
                }).collect(Collectors.toList());

        this.messageRepository.saveAll(messageEntities);
    }
}
