package com.bcxin.runtime.domain.messages.commands;

import com.bcxin.saas.core.commands.CommandAbstract;
import com.bcxin.saas.core.enums.MessageType;
import com.bcxin.saas.core.enums.ReceiverType;
import lombok.Getter;

@Getter
public class CreateMessageCommand extends CommandAbstract {
    private final String senderId;
    private final MessageType messageType;
    private final String title;
    private final String content;
    private final ReceiverType receiverType;
    private final String receiver;
    private final Object parameter;
    private final String businessNumber;
    private final String uniqueId;

    public CreateMessageCommand(String senderId, MessageType messageType,String title, String content,
                                ReceiverType receiverType, String receiver, Object parameter,
                                String businessNumber, String uniqueId) {
        this.senderId = senderId;
        this.messageType = messageType;
        this.content = content;
        this.receiverType = receiverType;
        this.receiver = receiver;
        this.parameter = parameter;
        this.businessNumber = businessNumber;
        this.uniqueId = uniqueId;
        this.title = title;
    }

    @Override
    protected void validate() {

    }

    public static CreateMessageCommand create(String senderId, MessageType messageType,String title, String content,
                                              ReceiverType receiverType, String receiver, Object parameter,
                                              String businessNumber, String uniqueId) {
        return new CreateMessageCommand(senderId, messageType, title, content, receiverType, receiver,
                parameter, businessNumber, uniqueId);
    }
}
