/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.syncs.services.impls;

import com.bcxin.runtime.domain.syncs.commands.CreateDataSyncMapCommand;
import com.bcxin.runtime.domain.syncs.commands.UpdateDataSyncMapCommand;
import com.bcxin.runtime.domain.syncs.entities.DataSyncMapEntity;
import com.bcxin.runtime.domain.syncs.repositories.DataSyncMapRepository;
import com.bcxin.runtime.domain.syncs.services.DataSyncMapService;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import java.util.Collections;

public class DataSyncMapServiceImpl
implements DataSyncMapService {
    private final DataSyncMapRepository dataSyncMapRepository;
    private final JsonProvider jsonProvider;

    public DataSyncMapServiceImpl(DataSyncMapRepository dataSyncMapRepository, JsonProvider jsonProvider) {
        this.dataSyncMapRepository = dataSyncMapRepository;
        this.jsonProvider = jsonProvider;
    }

    @Override
    public void create(CreateDataSyncMapCommand command) {
        String jsonMap = this.jsonProvider.getJson((Object)command.getJdbcMap());
        DataSyncMapEntity dataSyncMapEntity = DataSyncMapEntity.create(command.getMapKey(), jsonMap);
        this.dataSyncMapRepository.saveAll(Collections.singleton(dataSyncMapEntity));
    }

    @Override
    public void update(UpdateDataSyncMapCommand command) {
        DataSyncMapEntity dataSyncMapEntity = this.dataSyncMapRepository.getById(command.getId());
        if (dataSyncMapEntity == null) {
            throw new SaasNofoundException(String.format("\u627e\u4e0d\u5230\u6620\u5c04\u6570\u636e(%s)", command.getId()));
        }
        String jsonMap = this.jsonProvider.getJson((Object)command.getJdbcMap());
        dataSyncMapEntity.change(command.getMapKey(), jsonMap);
        this.dataSyncMapRepository.saveAll(Collections.singleton(dataSyncMapEntity));
    }

    @Override
    public void delete(String id) {
        DataSyncMapEntity dataSyncMapEntity = this.dataSyncMapRepository.getById(id);
        if (dataSyncMapEntity == null) {
            throw new SaasNofoundException("\u627e\u4e0d\u5230\u6570\u636e\u914d\u7f6e");
        }
        this.dataSyncMapRepository.delete(dataSyncMapEntity);
    }
}

