/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.syncs.entities;

import com.bcxin.runtime.domain.enums.BooleanStatus;
import com.bcxin.saas.core.IAggregate;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="sync_frm_file_queues")
public class FileSyncQueueEntity
implements IAggregate {
    @Id
    private String id;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", nullable=false)
    private Date createdTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_processed_time", nullable=true)
    private Date lastProcessedTime;
    @Column(nullable=false, name="download_url", length=800)
    private String downloadUrl;
    @Column(name="path", length=500)
    private String path;
    @Column(length=8000)
    private String result;
    @Column(name="sync_queue_id", nullable=false)
    private String syncQueueId;
    @Column(name="sync_log_id", nullable=false)
    private String syncLogId;
    @Column(name="is_downloaded", nullable=false)
    private BooleanStatus isDownloaded;
    @Column(name="retry_count", nullable=false)
    private int retryCount;

    public void makeStatus(boolean isSuccess, String msg) {
        this.setLastProcessedTime(new Date());
        this.setIsDownloaded(isSuccess ? BooleanStatus.TRUE : BooleanStatus.FALSE);
        this.setResult(msg);
        this.setRetryCount(this.getRetryCount() + 1);
    }

    protected FileSyncQueueEntity() {
    }

    public FileSyncQueueEntity(String downloadUrl, String path, String syncQueueId, String syncLogId) {
        this.setId(UUID.randomUUID().toString());
        this.setSyncQueueId(syncQueueId);
        this.setSyncLogId(syncLogId);
        this.setDownloadUrl(downloadUrl);
        this.setPath(path);
        this.setCreatedTime(new Date());
        this.setIsDownloaded(BooleanStatus.FALSE);
    }

    public static FileSyncQueueEntity create(String downloadUrl, String path, String syncQueueId, String syncLogId) {
        return new FileSyncQueueEntity(downloadUrl, path, syncQueueId, syncLogId);
    }

    public String getId() {
        return this.id;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getLastProcessedTime() {
        return this.lastProcessedTime;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getPath() {
        return this.path;
    }

    public String getResult() {
        return this.result;
    }

    public String getSyncQueueId() {
        return this.syncQueueId;
    }

    public String getSyncLogId() {
        return this.syncLogId;
    }

    public BooleanStatus getIsDownloaded() {
        return this.isDownloaded;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    protected void setLastProcessedTime(Date lastProcessedTime) {
        this.lastProcessedTime = lastProcessedTime;
    }

    protected void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    protected void setResult(String result) {
        this.result = result;
    }

    protected void setSyncQueueId(String syncQueueId) {
        this.syncQueueId = syncQueueId;
    }

    protected void setSyncLogId(String syncLogId) {
        this.syncLogId = syncLogId;
    }

    protected void setIsDownloaded(BooleanStatus isDownloaded) {
        this.isDownloaded = isDownloaded;
    }

    protected void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }
}

