/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.syncs.entities;

import com.bcxin.runtime.domain.enums.BooleanStatus;
import com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus;
import com.bcxin.saas.core.IAggregate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="sync_frm_data_queues")
public class DataSyncQueueEntity
implements IAggregate {
    private static final Logger logger = LoggerFactory.getLogger(DataSyncQueueEntity.class);
    private static final Collection<SyncProcessStatus> completedSyncProcessedStatuses = Arrays.asList(SyncProcessStatus.Done, SyncProcessStatus.DoneFromCallback, SyncProcessStatus.DoneViaFTP);
    private static final Collection<SyncProcessStatus> errorSyncProcessedStatuses = Arrays.asList(SyncProcessStatus.Error, SyncProcessStatus.ErrorFromCallback, SyncProcessStatus.ErrorViaFTP);
    public static final String CALLBACK_MSG_ID = "msgId";
    public static final String CALLBACK_RESULT = "result";
    public static final String CALLBACK_EXEC_STATUS = "execStatus";
    @Id
    private String id;
    @Column(name="name", length=300)
    private String name;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", nullable=false)
    private Date createdTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_processed_time", nullable=true)
    private Date lastProcessedTime;
    @Column(nullable=false, length=3000)
    private String data;
    @Column(name="size", nullable=false)
    private int size;
    @Column(name="need_sync_file", nullable=false)
    private BooleanStatus needSyncFile;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="file_sync_status", nullable=false)
    private SyncProcessStatus fileSyncStatus;
    @Column(name="file_sync_result")
    private String fileSyncResult;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_file_processed_time")
    private Date lastFileProcessedTime;
    @Column(name="form_sync_config", nullable=false, length=5000)
    private String formSyncConfig;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=false)
    private SyncProcessStatus status;
    @Column(name="is_archived", nullable=false)
    private BooleanStatus isArchived;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="archived_time")
    public Date ArchivedTime;
    @Column(name="retry_count", nullable=false)
    private int retryCount;
    @Column(length=8000)
    private String result;
    @Column(name="form_sync_id", nullable=false, length=100)
    private String formSyncId;
    @Column(name="short_result", length=800)
    private String shortResult;
    @Column(name="third_party_reference_id", length=100)
    private String thirdPartyReferenceId;
    @Column(name="third_party_callback", length=2000)
    private String thirdPartyCallback;
    @Column(name="third_party_tracking", length=3000)
    private String thirdPartyTracking;

    public void makeArchived() {
        this.setIsArchived(BooleanStatus.TRUE);
        this.setArchivedTime(new Date());
    }

    public void changeDataSyncStatus(SyncProcessStatus status, String result) {
        this.setStatus(status);
        this.setResult(result);
        this.setLastProcessedTime(new Date());
    }

    public void changeFileSyncStatus(SyncProcessStatus status, String result) {
        this.setFileSyncStatus(status);
        this.setFileSyncResult(result);
        this.setLastFileProcessedTime(new Date());
    }

    public void refreshDate(String data) {
        this.setLastProcessedTime(new Date());
        this.setData(data);
    }

    protected DataSyncQueueEntity() {
    }

    protected DataSyncQueueEntity(String name, String data, int size, boolean needSyncFile, String formSyncId, String formSyncConfig) {
        this.setId(UUID.randomUUID().toString());
        this.setNeedSyncFile(needSyncFile ? BooleanStatus.TRUE : BooleanStatus.FALSE);
        this.setSize(size);
        this.setCreatedTime(new Date());
        this.setName(name);
        this.setData(data);
        this.setStatus(SyncProcessStatus.Initialize);
        this.setFileSyncStatus(SyncProcessStatus.Initialize);
        this.setFormSyncConfig(formSyncConfig);
        this.setFormSyncId(formSyncId);
        this.setIsArchived(BooleanStatus.FALSE);
        if (!needSyncFile) {
            this.changeFileSyncStatus(SyncProcessStatus.Done, "\u65e0\u9700\u540c\u6b65\u6587\u4ef6");
        }
    }

    public static DataSyncQueueEntity create(String name, String data, int size, boolean needSyncFile, String referenceId, String formSyncConfig) {
        return new DataSyncQueueEntity(name, data, size, needSyncFile, referenceId, formSyncConfig);
    }

    public void assignThirdParty(boolean dispatchFile, SyncProcessStatus status, String thirdPartyReferenceId, String result) {
        this.setThirdPartyTracking(String.format("%s;%s-%s", new Object[]{this.getThirdPartyTracking(), thirdPartyReferenceId, status}));
        this.setThirdPartyReferenceId(thirdPartyReferenceId);
        if (dispatchFile) {
            this.changeFileSyncStatus(status, result);
        } else {
            this.changeDataSyncStatus(status, result);
        }
    }

    public void assignCallback(String execStatus, String callBack) {
        if ("1".equals(execStatus)) {
            this.setStatus(SyncProcessStatus.DoneFromCallback);
        } else {
            this.setStatus(SyncProcessStatus.ErrorFromCallback);
        }
        this.setThirdPartyCallback(callBack);
    }

    public void retry(String message) {
        if (errorSyncProcessedStatuses.contains((Object)this.getStatus())) {
            this.changeDataSyncStatus(this.getStatus() == SyncProcessStatus.Error ? SyncProcessStatus.Initialize : SyncProcessStatus.SyncViaFTP, message);
        }
        if (errorSyncProcessedStatuses.contains((Object)this.getFileSyncStatus())) {
            this.changeFileSyncStatus(this.getFileSyncStatus() == SyncProcessStatus.Error ? SyncProcessStatus.Initialize : SyncProcessStatus.SyncViaFTP, message);
        }
        this.setRetryCount(this.getRetryCount() + 1);
        this.setLastProcessedTime(new Date());
    }

    public void changeFileSyncStatusAndRetryCount(SyncProcessStatus status, String result) {
        this.setFileSyncStatus(status);
        this.setFileSyncResult(result);
        this.setLastFileProcessedTime(new Date());
        this.setRetryCount(this.getRetryCount() + 1);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getLastProcessedTime() {
        return this.lastProcessedTime;
    }

    public String getData() {
        return this.data;
    }

    public int getSize() {
        return this.size;
    }

    public BooleanStatus getNeedSyncFile() {
        return this.needSyncFile;
    }

    public SyncProcessStatus getFileSyncStatus() {
        return this.fileSyncStatus;
    }

    public String getFileSyncResult() {
        return this.fileSyncResult;
    }

    public Date getLastFileProcessedTime() {
        return this.lastFileProcessedTime;
    }

    public String getFormSyncConfig() {
        return this.formSyncConfig;
    }

    public SyncProcessStatus getStatus() {
        return this.status;
    }

    public BooleanStatus getIsArchived() {
        return this.isArchived;
    }

    public Date getArchivedTime() {
        return this.ArchivedTime;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public String getResult() {
        return this.result;
    }

    public String getFormSyncId() {
        return this.formSyncId;
    }

    public String getShortResult() {
        return this.shortResult;
    }

    public String getThirdPartyReferenceId() {
        return this.thirdPartyReferenceId;
    }

    public String getThirdPartyCallback() {
        return this.thirdPartyCallback;
    }

    public String getThirdPartyTracking() {
        return this.thirdPartyTracking;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    protected void setLastProcessedTime(Date lastProcessedTime) {
        this.lastProcessedTime = lastProcessedTime;
    }

    protected void setData(String data) {
        this.data = data;
    }

    protected void setSize(int size) {
        this.size = size;
    }

    protected void setNeedSyncFile(BooleanStatus needSyncFile) {
        this.needSyncFile = needSyncFile;
    }

    protected void setFileSyncStatus(SyncProcessStatus fileSyncStatus) {
        this.fileSyncStatus = fileSyncStatus;
    }

    protected void setFileSyncResult(String fileSyncResult) {
        this.fileSyncResult = fileSyncResult;
    }

    protected void setLastFileProcessedTime(Date lastFileProcessedTime) {
        this.lastFileProcessedTime = lastFileProcessedTime;
    }

    protected void setFormSyncConfig(String formSyncConfig) {
        this.formSyncConfig = formSyncConfig;
    }

    protected void setStatus(SyncProcessStatus status) {
        this.status = status;
    }

    protected void setIsArchived(BooleanStatus isArchived) {
        this.isArchived = isArchived;
    }

    protected void setArchivedTime(Date ArchivedTime) {
        this.ArchivedTime = ArchivedTime;
    }

    protected void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    protected void setResult(String result) {
        this.result = result;
    }

    protected void setFormSyncId(String formSyncId) {
        this.formSyncId = formSyncId;
    }

    protected void setThirdPartyReferenceId(String thirdPartyReferenceId) {
        this.thirdPartyReferenceId = thirdPartyReferenceId;
    }

    protected void setThirdPartyCallback(String thirdPartyCallback) {
        this.thirdPartyCallback = thirdPartyCallback;
    }

    protected void setThirdPartyTracking(String thirdPartyTracking) {
        this.thirdPartyTracking = thirdPartyTracking;
    }

    public void setShortResult(String shortResult) {
        this.shortResult = shortResult;
    }

    private static class ThirdPartyHistory {
        private String id;
        private SyncProcessStatus status;
        private Date executedTime;
        private String result;

        public static ThirdPartyHistory create(String id, SyncProcessStatus status, String result) {
            ThirdPartyHistory thirdPartyHistory = new ThirdPartyHistory();
            thirdPartyHistory.setId(id);
            thirdPartyHistory.setResult(result);
            thirdPartyHistory.setStatus(status);
            thirdPartyHistory.setExecutedTime(new Date());
            return thirdPartyHistory;
        }

        public String getId() {
            return this.id;
        }

        public SyncProcessStatus getStatus() {
            return this.status;
        }

        public Date getExecutedTime() {
            return this.executedTime;
        }

        public String getResult() {
            return this.result;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setStatus(SyncProcessStatus status) {
            this.status = status;
        }

        public void setExecutedTime(Date executedTime) {
            this.executedTime = executedTime;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThirdPartyHistory)) {
                return false;
            }
            ThirdPartyHistory other = (ThirdPartyHistory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            SyncProcessStatus this$status = this.getStatus();
            SyncProcessStatus other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            Date this$executedTime = this.getExecutedTime();
            Date other$executedTime = other.getExecutedTime();
            if (this$executedTime == null ? other$executedTime != null : !((Object)this$executedTime).equals(other$executedTime)) {
                return false;
            }
            String this$result = this.getResult();
            String other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThirdPartyHistory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            SyncProcessStatus $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            Date $executedTime = this.getExecutedTime();
            result = result * 59 + ($executedTime == null ? 43 : ((Object)$executedTime).hashCode());
            String $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "DataSyncQueueEntity.ThirdPartyHistory(id=" + this.getId() + ", status=" + (Object)((Object)this.getStatus()) + ", executedTime=" + this.getExecutedTime() + ", result=" + this.getResult() + ")";
        }
    }
}

