/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.syncs.entities;

import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="sync_data_maps")
public class DataSyncMapEntity
extends EntityBase<String>
implements IAggregate {
    @Id
    private String id;
    @Column(name="map_key", length=200, nullable=false)
    private String mapKey;
    @Column(name="target_config", nullable=false, length=2000)
    private String targetConfig;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_updated_time", nullable=false)
    private Date lastUpdatedTime;
    @Column(name="created_time", nullable=false)
    private Date createdTime;

    protected DataSyncMapEntity() {
    }

    protected DataSyncMapEntity(String mapKey, String targetConfig) {
        this.setId(UUID.randomUUID().toString());
        this.setMapKey(mapKey);
        this.setTargetConfig(targetConfig);
        this.setCreatedTime(new Date());
        this.setLastUpdatedTime(this.getCreatedTime());
    }

    public static DataSyncMapEntity create(String mapKey, String targetConfig) {
        return new DataSyncMapEntity(mapKey, targetConfig);
    }

    public void change(String mapKey, String targetConfig) {
        this.setLastUpdatedTime(new Date());
        this.setMapKey(mapKey);
        this.setTargetConfig(targetConfig);
    }

    public String getId() {
        return this.id;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public String getTargetConfig() {
        return this.targetConfig;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    protected void setTargetConfig(String targetConfig) {
        this.targetConfig = targetConfig;
    }

    protected void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }
}

