/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.syncs.commands;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.google.common.io.Files;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class CreateDataSyncCommand {
    private final Collection<DataSet> dataSets;
    private final String filePaths;
    private final Map<String, String> urlFilePathMappings;

    public CreateDataSyncCommand(Collection<DataSet> dataSets, String filePaths, Map<String, String> urlFilePathMappings) {
        this.dataSets = dataSets;
        this.filePaths = filePaths;
        this.urlFilePathMappings = urlFilePathMappings;
    }

    public String getDataSetId() {
        if (this.getDataSets() == null || this.getDataSets().isEmpty()) {
            return null;
        }
        return this.getDataSets().stream().map(ix -> ix.getId()).findFirst().get();
    }

    public String getOriginalDownloadUrl(String downloadUrl) {
        String originalDownloadUrl;
        StringBuilder track = new StringBuilder(String.format("downloadUrl=%s;", downloadUrl));
        String mappingKey = downloadUrl;
        if (downloadUrl.contains("=")) {
            mappingKey = String.format("%s.%s", Files.getNameWithoutExtension((String)downloadUrl), Files.getFileExtension((String)downloadUrl));
        }
        if (StringUtils.isEmpty((CharSequence)(originalDownloadUrl = this.getMatchKeyValue(mappingKey)))) {
            mappingKey = downloadUrl;
            originalDownloadUrl = this.getMatchKeyValue(mappingKey);
        }
        if (StringUtils.isEmpty((CharSequence)originalDownloadUrl)) {
            int index = downloadUrl.lastIndexOf("/");
            String fileName = downloadUrl.substring(index);
            Optional<String> keyOptional = this.getUrlFilePathMappings().keySet().stream().filter(ii -> ii.contains(fileName)).findFirst();
            if (keyOptional.isPresent()) {
                mappingKey = keyOptional.get();
            }
            originalDownloadUrl = this.getMatchKeyValue(mappingKey);
        }
        return originalDownloadUrl;
    }

    private String getMatchKeyValue(String subKey) {
        if (this.getUrlFilePathMappings() == null) {
            return null;
        }
        Optional<String> keyOptional = this.getUrlFilePathMappings().keySet().stream().filter(ii -> ii.contains(subKey)).findFirst();
        if (keyOptional.isPresent()) {
            return this.getUrlFilePathMappings().get(keyOptional.get());
        }
        return null;
    }

    public static CreateDataSyncCommand create(Collection<DataSet> dataSets, String filePaths, Map<String, String> urlFilePathMappings) {
        if (!StringUtils.isEmpty((CharSequence)filePaths) && CollectionUtil.isEmpty(urlFilePathMappings)) {
            throw new SaasBadException(String.format("\u6570\u636e\u683c\u5f0f\u65e0\u6548(filePaths\u6709\u503c\u7684\u65f6\u5019, urlFilePathMappings\u4e0d\u5e94\u8be5\u4e3a\u7a7a)!", new Object[0]));
        }
        return new CreateDataSyncCommand(dataSets, filePaths, urlFilePathMappings);
    }

    public Collection<DataSet> getDataSets() {
        return this.dataSets;
    }

    public String getFilePaths() {
        return this.filePaths;
    }

    public Map<String, String> getUrlFilePathMappings() {
        return this.urlFilePathMappings;
    }

    public static class DataSet {
        private final String id;
        private final String mapKey;
        private final Collection<DataSetDto.Row> rows;
        private final Collection<String> deletedIds;

        public DataSet(String id, String mapKey, Collection<DataSetDto.Row> rows, Collection<String> deletedIds) {
            this.id = id;
            this.mapKey = mapKey;
            this.rows = rows;
            this.deletedIds = deletedIds;
        }

        public static DataSet create(String id, String mapKey, Collection<DataSetDto.Row> rows, Collection<String> deletedIds) {
            return new DataSet(id, mapKey, rows, deletedIds);
        }

        public String getAutoMapTableName(String regexDataMap) {
            if (this.mapKey == null) {
                return null;
            }
            int lastSplitIndex = this.mapKey.lastIndexOf("|");
            if (lastSplitIndex < 0) {
                return this.mapKey;
            }
            return this.mapKey.substring(lastSplitIndex + 1);
        }

        public String getId() {
            return this.id;
        }

        public String getMapKey() {
            return this.mapKey;
        }

        public Collection<DataSetDto.Row> getRows() {
            return this.rows;
        }

        public Collection<String> getDeletedIds() {
            return this.deletedIds;
        }
    }
}

