/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.metas.services.impls;

import com.bcxin.runtime.domain.metas.commands.RefreshTaskCommand;
import com.bcxin.runtime.domain.metas.entities.ApplicationMetaEntity;
import com.bcxin.runtime.domain.metas.entities.TaskMetaEntity;
import com.bcxin.runtime.domain.metas.repositories.ApplicationMetaRepository;
import com.bcxin.runtime.domain.metas.repositories.TaskMetaRepository;
import com.bcxin.runtime.domain.metas.services.TaskMetaService;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TaskMetaServiceImpl
implements TaskMetaService {
    private final TaskMetaRepository taskMetaRepository;
    private final JsonProvider jsonProvider;
    private final ApplicationMetaRepository applicationMetaRepository;

    public TaskMetaServiceImpl(TaskMetaRepository taskMetaRepository, JsonProvider jsonProvider, ApplicationMetaRepository applicationMetaRepository) {
        this.taskMetaRepository = taskMetaRepository;
        this.jsonProvider = jsonProvider;
        this.applicationMetaRepository = applicationMetaRepository;
    }

    @Override
    public void refresh(RefreshTaskCommand command) {
        List<TaskMetaEntity> taskMetaEntities = this.taskMetaRepository.findAll();
        ArrayList toLoadedApps = new ArrayList();
        command.getTasks().forEach(tk -> {
            Optional<TaskMetaEntity> metaEntityOptional = taskMetaEntities.stream().filter(ii -> ii.getTaskId().equals(tk.getId())).findFirst();
            if (metaEntityOptional.isPresent()) {
                metaEntityOptional.get().change(tk.getName(), tk.getConfig().getStartupType(), tk.getDesc(), this.jsonProvider.getJson((Object)tk.getConfig()));
            } else {
                Optional<ApplicationMetaEntity> applicationMetaEntityOptional = toLoadedApps.stream().filter(ix -> ix.getAppId().equals(tk.getAppId())).findFirst();
                if (!applicationMetaEntityOptional.isPresent()) {
                    throw new SaasNofoundException();
                }
                this.applicationMetaRepository.getById(tk.getAppId());
                taskMetaEntities.add(TaskMetaEntity.create(applicationMetaEntityOptional.get(), tk.getId(), tk.getName(), tk.getPath(), tk.getDesc(), this.jsonProvider.getJson((Object)tk.getConfig())));
            }
        });
        taskMetaEntities.forEach(ii -> {
            if (command.getTasks().stream().anyMatch(tk -> tk.getId().equals(ii.getTaskId()))) {
                taskMetaEntities.remove(ii);
            }
        });
        this.taskMetaRepository.saveAll(taskMetaEntities);
    }
}

