/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.metas.services.impls;

import com.bcxin.runtime.domain.metas.commands.RefreshFormSyncTargetMetaCommand;
import com.bcxin.runtime.domain.metas.entities.FormSyncTargetMetaEntity;
import com.bcxin.runtime.domain.metas.repositories.FormSyncTargetMetaRepository;
import com.bcxin.runtime.domain.metas.services.FormSyncTargetMetaService;
import com.bcxin.runtime.domain.snapshoots.FormSyncTargetConfigSnapshot;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Collectors;

public class FormSyncTargetMetaServiceImpl
implements FormSyncTargetMetaService {
    private final FormSyncTargetMetaRepository formSyncTargetMetaRepository;
    private final JsonProvider jsonProvider;

    public FormSyncTargetMetaServiceImpl(FormSyncTargetMetaRepository formSyncTargetMetaRepository, JsonProvider jsonProvider) {
        this.formSyncTargetMetaRepository = formSyncTargetMetaRepository;
        this.jsonProvider = jsonProvider;
    }

    @Override
    public void saveAll(RefreshFormSyncTargetMetaCommand command) {
        Collection targetMetaEntities = command.getFormSyncTargetMetas().stream().map(ii -> {
            FormSyncTargetConfigSnapshot formSyncTargetConfigSnapshot = FormSyncTargetConfigSnapshot.create(ii.getTargetType(), ii.getUrl(), ii.getFileUploadUrl(), ii.getMethod(), ii.getHeaders(), ii.getBodyAdditionalData());
            String config = this.jsonProvider.getJson((Object)formSyncTargetConfigSnapshot);
            FormSyncTargetMetaEntity targetMetaEntity = FormSyncTargetMetaEntity.create(ii.getCode(), ii.getUrl(), ii.getMethod(), config, "\u914d\u7f6e\u76ee\u6807\u6570\u636e\u6e90");
            return targetMetaEntity;
        }).collect(Collectors.toList());
        this.formSyncTargetMetaRepository.saveAll(targetMetaEntities);
    }

    @Override
    public void update(RefreshFormSyncTargetMetaCommand command) {
        Collection targetCodes = command.getFormSyncTargetMetas().stream().map(ii -> ii.getCode()).distinct().collect(Collectors.toList());
        Collection<FormSyncTargetMetaEntity> targetMetaEntities = this.formSyncTargetMetaRepository.getAll(targetCodes);
        targetMetaEntities.forEach(target -> {
            Optional<RefreshFormSyncTargetMetaCommand.FormSyncTargetMeta> formSyncTargetMetaEntityOptional = command.getFormSyncTargetMetas().stream().filter(ii -> ii.getCode().equalsIgnoreCase(target.getId())).findFirst();
            if (formSyncTargetMetaEntityOptional.isPresent()) {
                RefreshFormSyncTargetMetaCommand.FormSyncTargetMeta formSyncTargetMeta = formSyncTargetMetaEntityOptional.get();
                FormSyncTargetConfigSnapshot formSyncTargetConfigSnapshot = FormSyncTargetConfigSnapshot.create(formSyncTargetMeta.getTargetType(), formSyncTargetMeta.getUrl(), formSyncTargetMeta.getFileUploadUrl(), formSyncTargetMeta.getMethod(), formSyncTargetMeta.getHeaders(), formSyncTargetMeta.getBodyAdditionalData());
                String config = this.jsonProvider.getJson((Object)formSyncTargetConfigSnapshot);
                target.change(formSyncTargetMeta.getUrl(), formSyncTargetMeta.getMethod(), config, String.format("%s:%s", new Date(), target.getNote()));
            }
        });
        this.formSyncTargetMetaRepository.saveAll(targetMetaEntities);
    }

    @Override
    public void delete(String code) {
        FormSyncTargetMetaEntity formSyncTargetMetaEntity = this.formSyncTargetMetaRepository.getById(code);
        if (formSyncTargetMetaEntity == null) {
            throw new SaasNofoundException(String.format("\u627e\u4e0d\u5230\u76ee\u6807\u914d\u7f6e(%s)", code));
        }
        this.formSyncTargetMetaRepository.delete(formSyncTargetMetaEntity);
    }
}

