/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.metas.services.impls;

import com.bcxin.runtime.domain.constants.SyncMapConstant;
import com.bcxin.runtime.domain.metas.commands.BatchCreateFormSyncMetaCommand;
import com.bcxin.runtime.domain.metas.commands.CreateFormSyncMetaCommand;
import com.bcxin.runtime.domain.metas.entities.ApplicationMetaEntity;
import com.bcxin.runtime.domain.metas.entities.FormMetaEntity;
import com.bcxin.runtime.domain.metas.entities.FormSyncMetaEntity;
import com.bcxin.runtime.domain.metas.entities.FormSyncTargetMetaEntity;
import com.bcxin.runtime.domain.metas.entities.enums.FormType;
import com.bcxin.runtime.domain.metas.repositories.ApplicationMetaRepository;
import com.bcxin.runtime.domain.metas.repositories.FormSyncMetaRepository;
import com.bcxin.runtime.domain.metas.repositories.FormSyncTargetMetaRepository;
import com.bcxin.runtime.domain.metas.services.FormSyncMetaService;
import com.bcxin.runtime.domain.snapshoots.FormSyncConfigSnapshot;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

public class FormSyncMetaServiceImpl
implements FormSyncMetaService {
    private final FormSyncMetaRepository formSyncMetaRepository;
    private final ApplicationMetaRepository applicationMetaRepository;
    private final JsonProvider jsonProvider;
    private final FormSyncTargetMetaRepository formSyncTargetMetaRepository;

    public FormSyncMetaServiceImpl(FormSyncMetaRepository formSyncMetaRepository, ApplicationMetaRepository applicationMetaRepository, JsonProvider jsonProvider, FormSyncTargetMetaRepository formSyncTargetMetaRepository) {
        this.formSyncMetaRepository = formSyncMetaRepository;
        this.applicationMetaRepository = applicationMetaRepository;
        this.jsonProvider = jsonProvider;
        this.formSyncTargetMetaRepository = formSyncTargetMetaRepository;
    }

    @Override
    public void saveAll(CreateFormSyncMetaCommand command) {
        Collection formIds = command.getFormSyncs().stream().map(ii -> ii.getFormId()).collect(Collectors.toList());
        Collection<FormMetaEntity> formMetaEntities = this.applicationMetaRepository.getFormMetasByFormIds(formIds);
        Collection formSyncMetaEntities = command.getFormSyncs().stream().map(fs -> {
            Optional<FormMetaEntity> formMetaEntityOptional = formMetaEntities.stream().filter(ix -> ix.getFormId().equals(fs.getFormId())).findFirst();
            if (!formMetaEntityOptional.isPresent()) {
                throw new SaasNofoundException(String.format("FormId(%s)\u4e0d\u5b58\u5728", fs.getFormId()));
            }
            FormSyncTargetMetaEntity targetMetaEntity = this.formSyncTargetMetaRepository.getById(fs.getTargetId());
            if (targetMetaEntity == null) {
                throw new SaasNofoundException(String.format("TargetId(%s)\u4e0d\u5b58\u5728", fs.getFormId()));
            }
            String config = this.jsonProvider.getJson((Object)fs.getConfig());
            FormSyncMetaEntity formSyncMetaEntity = FormSyncMetaEntity.create(formMetaEntityOptional.get(), fs.isOnline(), config, targetMetaEntity, fs.getNote());
            return formSyncMetaEntity;
        }).filter(ii -> ii != null).collect(Collectors.toList());
        this.formSyncMetaRepository.saveAll(formSyncMetaEntities);
    }

    @Override
    public void delete(String id) {
        FormSyncMetaEntity formSyncMetaEntity = this.formSyncMetaRepository.getById(id);
        if (formSyncMetaEntity == null) {
            throw new SaasNofoundException(String.format("\u627e\u4e0d\u540c\u6b65\u8868\u5355\u914d\u7f6e\u4fe1\u606f(%s)", id));
        }
        this.formSyncMetaRepository.delete(formSyncMetaEntity);
    }

    @Override
    public void batch(BatchCreateFormSyncMetaCommand command) {
        ApplicationMetaEntity applicationMetaEntity = this.applicationMetaRepository.getById(command.getAppId());
        if (applicationMetaEntity == null) {
            throw new SaasNofoundException(String.format("App(%s)\u627e\u4e0d\u5230", command.getAppId()));
        }
        FormSyncTargetMetaEntity targetMetaEntity = this.formSyncTargetMetaRepository.getById(command.getTargetId());
        if (targetMetaEntity == null) {
            throw new SaasNofoundException(String.format("Target\u76ee\u6807(%s)\u627e\u4e0d\u5230", command.getTargetId()));
        }
        Collection<FormMetaEntity> formMetaEntities = applicationMetaEntity.getFormMetas();
        Collection formSyncMetaEntities = formMetaEntities.stream().filter(ii -> ii.getFormType() == FormType.NORMAL).map(form -> {
            FormSyncConfigSnapshot configSnapshot = FormSyncConfigSnapshot.create(SyncMapConstant.getMetaMapKey(command.getTargetId(), form.getTableName()), null);
            String config = this.jsonProvider.getJson((Object)configSnapshot);
            FormSyncMetaEntity formSyncMetaEntity = FormSyncMetaEntity.create(form, true, config, targetMetaEntity, "\u6279\u91cf\u6dfb\u52a0\u8868\u5355\u4fe1\u606f");
            return formSyncMetaEntity;
        }).collect(Collectors.toList());
        this.formSyncMetaRepository.saveAll(formSyncMetaEntities);
    }
}

