/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.metas.entities;

import com.bcxin.runtime.domain.metas.entities.ApplicationMetaEntity;
import com.bcxin.runtime.domain.metas.entities.enums.StartupType;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="meta_tasks")
public class TaskMetaEntity
extends EntityBase<String>
implements IAggregate {
    @Id
    @Column(length=50)
    private String id;
    @Column(length=250)
    private String name;
    @Column(name="task_id", length=50, nullable=false)
    private String taskId;
    @Column(length=500)
    private String note;
    @Column(length=500, nullable=false)
    private String path;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_updated_time", nullable=false)
    private Date lastUpdatedTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_executed_time", nullable=true)
    private Date lastExecutedTime;
    @Column(name="executed_count", nullable=false)
    private int executedCount;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="startup_type", nullable=false)
    private StartupType startupType;
    @Column(columnDefinition="text")
    private String config;
    @ManyToOne
    @JoinColumn(name="application_meta_id")
    private ApplicationMetaEntity applicationMeta;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", nullable=false, columnDefinition="DATETIME default current_timestamp()")
    private Date createdTime;

    public void change(String name, StartupType startupType, String note, String config) {
        this.setName(name);
        this.setStartupType(startupType);
        this.setNote(note);
        this.setConfig(config);
        this.setLastExecutedTime(new Date());
    }

    protected TaskMetaEntity() {
        this.lastUpdatedTime = this.createdTime = new Date();
    }

    private TaskMetaEntity(ApplicationMetaEntity applicationMetaEntity, String taskId, String name, String path, String note, String config) {
        this();
        this.setId(UUID.randomUUID().toString());
        this.setTaskId(taskId);
        this.setName(name);
        this.setPath(path);
        this.setNote(note);
        this.setConfig(config);
        this.setApplicationMeta(applicationMetaEntity);
    }

    public static TaskMetaEntity create(ApplicationMetaEntity applicationMetaEntity, String taskId, String name, String path, String note, String config) {
        return new TaskMetaEntity(applicationMetaEntity, taskId, name, path, note, config);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getNote() {
        return this.note;
    }

    public String getPath() {
        return this.path;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Date getLastExecutedTime() {
        return this.lastExecutedTime;
    }

    public int getExecutedCount() {
        return this.executedCount;
    }

    public StartupType getStartupType() {
        return this.startupType;
    }

    public String getConfig() {
        return this.config;
    }

    public ApplicationMetaEntity getApplicationMeta() {
        return this.applicationMeta;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    protected void setNote(String note) {
        this.note = note;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    protected void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setLastExecutedTime(Date lastExecutedTime) {
        this.lastExecutedTime = lastExecutedTime;
    }

    protected void setExecutedCount(int executedCount) {
        this.executedCount = executedCount;
    }

    protected void setStartupType(StartupType startupType) {
        this.startupType = startupType;
    }

    protected void setConfig(String config) {
        this.config = config;
    }

    protected void setApplicationMeta(ApplicationMetaEntity applicationMeta) {
        this.applicationMeta = applicationMeta;
    }

    protected void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }
}

