/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.metas.entities;

import com.bcxin.runtime.domain.metas.entities.FormSyncMetaEntity;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.enums.HttpMethod;
import com.bcxin.saas.core.models.EntityBase;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="sync_meta_form_targets")
public class FormSyncTargetMetaEntity
extends EntityBase<String>
implements IAggregate {
    @Id
    private String id;
    @Column(length=500, nullable=false)
    private String url;
    @Enumerated
    @Column(nullable=false)
    private HttpMethod method;
    @Column(length=500)
    private String note;
    @Column(length=5000)
    private String config;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time")
    private Date createdTime;
    @OneToMany(mappedBy="targetMetaEntity")
    public Collection<FormSyncMetaEntity> metaEntities;

    protected FormSyncTargetMetaEntity() {
        this.setCreatedTime(new Date());
    }

    public static FormSyncTargetMetaEntity create(String code, String url, HttpMethod method, String config, String note) {
        FormSyncTargetMetaEntity formSyncTargetMetaEntity = new FormSyncTargetMetaEntity();
        formSyncTargetMetaEntity.setId(code);
        formSyncTargetMetaEntity.setUrl(url);
        formSyncTargetMetaEntity.setMethod(method);
        formSyncTargetMetaEntity.setConfig(config);
        formSyncTargetMetaEntity.setNote(note);
        return formSyncTargetMetaEntity;
    }

    public void change(String url, HttpMethod method, String config, String note) {
        this.setUrl(url);
        this.setMethod(method);
        this.setConfig(config);
        this.setNote(note);
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getNote() {
        return this.note;
    }

    public String getConfig() {
        return this.config;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Collection<FormSyncMetaEntity> getMetaEntities() {
        return this.metaEntities;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    protected void setMethod(HttpMethod method) {
        this.method = method;
    }

    protected void setNote(String note) {
        this.note = note;
    }

    protected void setConfig(String config) {
        this.config = config;
    }

    protected void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    protected void setMetaEntities(Collection<FormSyncMetaEntity> metaEntities) {
        this.metaEntities = metaEntities;
    }
}

