/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.metas.entities;

import com.bcxin.runtime.domain.enums.BooleanStatus;
import com.bcxin.runtime.domain.metas.entities.FormMetaEntity;
import com.bcxin.runtime.domain.metas.entities.FormSyncTargetMetaEntity;
import com.bcxin.runtime.domain.metas.entities.enums.FormSyncType;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="sync_meta_forms")
public class FormSyncMetaEntity
extends EntityBase<String>
implements IAggregate {
    @Id
    @Column(length=50)
    private String id;
    @Column(length=255, nullable=true)
    private String note;
    @Column(length=2000)
    private String config;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_updated_time")
    private Date lastUpdatedTime;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="form_meta_id")
    private FormMetaEntity formMeta;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_synced_time")
    private Date lastSyncedTime;
    @Column(name="synced_record_count")
    private int syncedRecordCount;
    @Column(name="is_online")
    private BooleanStatus isOnline;
    @Column(length=500)
    private String filter;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="target_meta_id", nullable=false)
    private FormSyncTargetMetaEntity targetMetaEntity;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", nullable=false, columnDefinition="DATETIME default current_timestamp()")
    private Date createdTime;

    protected FormSyncMetaEntity() {
        this.lastUpdatedTime = this.createdTime = new Date();
        this.setIsOnline(BooleanStatus.FALSE);
    }

    protected FormSyncMetaEntity(FormMetaEntity formMetaEntity, boolean isOnline, String config, FormSyncTargetMetaEntity formSyncTargetMetaEntity, String note) {
        this();
        assert (formMetaEntity != null);
        assert (note != null);
        this.setId(UUID.randomUUID().toString());
        this.setFormMeta(formMetaEntity);
        this.setTargetMetaEntity(formSyncTargetMetaEntity);
        this.setNote(note);
        this.setIsOnline(isOnline ? BooleanStatus.TRUE : BooleanStatus.FALSE);
        this.setConfig(config);
    }

    public void change(FormSyncType syncType, String note, String config) {
        this.setNote(note);
        this.setConfig(config);
    }

    public void markSyncQueue(Date lastSyncedTime, int syncedRecordCount, String note) {
        this.setLastSyncedTime(lastSyncedTime);
        this.setSyncedRecordCount(this.getSyncedRecordCount() + syncedRecordCount);
        this.setNote(note);
        this.setIsOnline(BooleanStatus.TRUE);
    }

    public static FormSyncMetaEntity create(FormMetaEntity formMetaEntity, boolean isOnline, String config, FormSyncTargetMetaEntity formSyncTargetMetaEntity, String note) {
        FormSyncMetaEntity formSyncMetaEntity = new FormSyncMetaEntity(formMetaEntity, isOnline, config, formSyncTargetMetaEntity, note);
        return formSyncMetaEntity;
    }

    public String getId() {
        return this.id;
    }

    public String getNote() {
        return this.note;
    }

    public String getConfig() {
        return this.config;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public FormMetaEntity getFormMeta() {
        return this.formMeta;
    }

    public Date getLastSyncedTime() {
        return this.lastSyncedTime;
    }

    public int getSyncedRecordCount() {
        return this.syncedRecordCount;
    }

    public BooleanStatus getIsOnline() {
        return this.isOnline;
    }

    public String getFilter() {
        return this.filter;
    }

    public FormSyncTargetMetaEntity getTargetMetaEntity() {
        return this.targetMetaEntity;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setNote(String note) {
        this.note = note;
    }

    protected void setConfig(String config) {
        this.config = config;
    }

    protected void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setFormMeta(FormMetaEntity formMeta) {
        this.formMeta = formMeta;
    }

    protected void setLastSyncedTime(Date lastSyncedTime) {
        this.lastSyncedTime = lastSyncedTime;
    }

    protected void setSyncedRecordCount(int syncedRecordCount) {
        this.syncedRecordCount = syncedRecordCount;
    }

    protected void setIsOnline(BooleanStatus isOnline) {
        this.isOnline = isOnline;
    }

    protected void setFilter(String filter) {
        this.filter = filter;
    }

    protected void setTargetMetaEntity(FormSyncTargetMetaEntity targetMetaEntity) {
        this.targetMetaEntity = targetMetaEntity;
    }

    protected void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }
}

