/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.metas.entities;

import com.bcxin.runtime.domain.enums.BooleanStatus;
import com.bcxin.runtime.domain.metas.entities.DataSourceMetaEntity;
import com.bcxin.runtime.domain.metas.entities.FormMetaEntity;
import com.bcxin.runtime.domain.metas.entities.enums.DbType;
import com.bcxin.runtime.domain.metas.entities.enums.FormType;
import com.bcxin.runtime.domain.metas.entities.enums.UseType;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="meta_apps")
public class ApplicationMetaEntity
extends EntityBase<String>
implements IAggregate {
    @Id
    @Column(length=50)
    private String id;
    @Column(length=100, nullable=false, name="app_id")
    private String appId;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false, name="is_online")
    private BooleanStatus isOnline;
    private String note;
    @OneToMany(mappedBy="applicationMeta", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Collection<DataSourceMetaEntity> dataSourceMetas;
    @OneToMany(mappedBy="applicationMeta", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Collection<FormMetaEntity> formMetas;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_updated_time", nullable=false)
    private Date lastUpdatedTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", nullable=false, columnDefinition="DATETIME default current_timestamp()")
    private Date createdTime;

    protected ApplicationMetaEntity() {
        this.lastUpdatedTime = this.createdTime = new Date();
        this.setIsOnline(BooleanStatus.FALSE);
    }

    public void change(String name, String note) {
        this.setName(name);
        this.setNote(note);
        this.setLastUpdatedTime(new Date());
    }

    public void addDataSourceMeta(String dataSourceId, String dsName, UseType dsDriveType, DbType dsDbType, String dsConfig, String dsNote, boolean isSelected) {
        if (this.getDataSourceMetas() != null) {
            Optional<DataSourceMetaEntity> metaEntityOptional = this.getDataSourceMetas().stream().filter(ii -> dataSourceId.equals(ii.getDataSourceId())).findFirst();
            if (metaEntityOptional.isPresent()) {
                metaEntityOptional.get().change(dsName, dsDriveType, dsDbType, dsConfig, dsNote);
                metaEntityOptional.get().setIsSelected(isSelected ? BooleanStatus.TRUE : BooleanStatus.FALSE);
                this.setLastUpdatedTime(new Date());
                return;
            }
        } else {
            this.dataSourceMetas = new ArrayList<DataSourceMetaEntity>();
        }
        DataSourceMetaEntity dataSourceMetaEntity = DataSourceMetaEntity.create(dataSourceId, dsName, dsDriveType, dsDbType, dsConfig, dsNote);
        dataSourceMetaEntity.setApplicationMeta(this);
        dataSourceMetaEntity.setIsSelected(isSelected ? BooleanStatus.TRUE : BooleanStatus.FALSE);
        this.getDataSourceMetas().add(dataSourceMetaEntity);
    }

    public void addFormMeta(String formId, String formName, String formTableName, FormType formType) {
        if (this.getFormMetas() != null) {
            Optional<FormMetaEntity> formMetaEntityOptional = this.getFormMetas().stream().filter(ii -> ii.getFormId().equals(formId)).findFirst();
            if (formMetaEntityOptional.isPresent()) {
                formMetaEntityOptional.get().change(formName, formTableName, formType);
                this.setLastUpdatedTime(new Date());
                return;
            }
        } else {
            this.formMetas = new ArrayList<FormMetaEntity>();
        }
        FormMetaEntity formMetaEntity = FormMetaEntity.create(formId, formName, formTableName, formType);
        formMetaEntity.setApplicationMeta(this);
        this.getFormMetas().add(formMetaEntity);
    }

    public static ApplicationMetaEntity create(String id, String appId, String name, boolean isOnline, String note) {
        ApplicationMetaEntity applicationMetaEntity = new ApplicationMetaEntity();
        applicationMetaEntity.setId(id);
        applicationMetaEntity.setName(name);
        applicationMetaEntity.setIsOnline(isOnline ? BooleanStatus.TRUE : BooleanStatus.FALSE);
        applicationMetaEntity.setNote(note);
        applicationMetaEntity.setAppId(appId);
        applicationMetaEntity.setFormMetas(new ArrayList<FormMetaEntity>());
        applicationMetaEntity.setDataSourceMetas(new ArrayList<DataSourceMetaEntity>());
        return applicationMetaEntity;
    }

    public String getId() {
        return this.id;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getName() {
        return this.name;
    }

    public BooleanStatus getIsOnline() {
        return this.isOnline;
    }

    public String getNote() {
        return this.note;
    }

    public Collection<DataSourceMetaEntity> getDataSourceMetas() {
        return this.dataSourceMetas;
    }

    public Collection<FormMetaEntity> getFormMetas() {
        return this.formMetas;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setAppId(String appId) {
        this.appId = appId;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setIsOnline(BooleanStatus isOnline) {
        this.isOnline = isOnline;
    }

    protected void setNote(String note) {
        this.note = note;
    }

    protected void setDataSourceMetas(Collection<DataSourceMetaEntity> dataSourceMetas) {
        this.dataSourceMetas = dataSourceMetas;
    }

    protected void setFormMetas(Collection<FormMetaEntity> formMetas) {
        this.formMetas = formMetas;
    }

    protected void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }
}

