/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.messages.entities;

import com.bcxin.runtime.domain.messages.enums.ProcessesStatus;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.enums.MessageType;
import com.bcxin.saas.core.enums.ReceiverType;
import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import com.bcxin.saas.core.models.EntityBase;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="shared_messages")
public class MessageEntity
extends EntityBase<String>
implements IAggregate {
    @Id
    @Column(length=50)
    private String id;
    @Column(name="title", length=500)
    private String title;
    @Column(name="content", nullable=false, length=5000)
    private String content;
    @Column(name="parameter_json", length=2000)
    private String parameterJson;
    @Column(name="sender_id", nullable=false, length=100)
    private String senderId;
    @Column(name="receiver", nullable=false, length=100)
    private String receiver;
    @Column(name="message_type", nullable=false)
    private MessageType messageType;
    @Column(name="receiver_type", nullable=false)
    private ReceiverType receiverType;
    @Column(name="status", nullable=false)
    private ProcessesStatus status;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @Column(name="last_processed_time")
    private Timestamp lastProcessedTime;
    @Column(name="business_number", length=500)
    private String businessNumber;
    @Column(name="unique_id", nullable=false, length=200)
    private String uniqueId;

    protected MessageEntity() {
    }

    protected MessageEntity(String senderId, MessageType messageType, String title, String content, ReceiverType receiverType, String receiver, Object parameter, String uniqueId, JsonProvider jsonProvider) {
        this.setId(UUID.randomUUID().toString());
        this.setMessageType(messageType);
        this.setContent(content);
        this.setReceiverType(receiverType);
        this.setReceiver(receiver);
        this.setSenderId(senderId);
        this.setParameterJson(jsonProvider.getJson(parameter));
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setStatus(ProcessesStatus.Init);
        this.setTitle(title);
        if (StringUtils.length((CharSequence)uniqueId) > 0) {
            this.setUniqueId(uniqueId);
        } else {
            this.setUniqueId(this.getId());
        }
    }

    public void assignBusinessNumber(String businessNumber) {
        if (StringUtils.length((CharSequence)this.getBusinessNumber()) > 0) {
            throw new SaasNoSupportException(String.format("\u65e0\u6cd5\u5bf9\u5df2\u7ecf\u5b58\u5728\u7684\u6d88\u606f\u8fdb\u884cBusinessNumber\u7684\u53d8\u66f4", new Object[0]));
        }
        this.setBusinessNumber(businessNumber);
    }

    public static MessageEntity create(String senderId, MessageType messageType, String title, String content, ReceiverType receiverType, String receiver, Object parameter, String uniqueId, JsonProvider jsonProvider) {
        return new MessageEntity(senderId, messageType, title, content, receiverType, receiver, parameter, uniqueId, jsonProvider);
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public String getParameterJson() {
        return this.parameterJson;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public ReceiverType getReceiverType() {
        return this.receiverType;
    }

    public ProcessesStatus getStatus() {
        return this.status;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getLastProcessedTime() {
        return this.lastProcessedTime;
    }

    public String getBusinessNumber() {
        return this.businessNumber;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected void setContent(String content) {
        this.content = content;
    }

    protected void setParameterJson(String parameterJson) {
        this.parameterJson = parameterJson;
    }

    protected void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    protected void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    protected void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    protected void setReceiverType(ReceiverType receiverType) {
        this.receiverType = receiverType;
    }

    protected void setStatus(ProcessesStatus status) {
        this.status = status;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setLastProcessedTime(Timestamp lastProcessedTime) {
        this.lastProcessedTime = lastProcessedTime;
    }

    protected void setBusinessNumber(String businessNumber) {
        this.businessNumber = businessNumber;
    }

    protected void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }
}

