package cn.myapps.versions.service;

import static org.junit.Assert.assertEquals;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import cn.myapps.common.constant.EnvironmentVariable;
import cn.myapps.common.model.versions.Versions;
import cn.myapps.designtime.common.service.DesignTimeServiceFactory;
import cn.myapps.run.Start;
import cn.myapps.util.sequence.Sequence;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= Start.class)
public class VersionsServiceTest {
	VersionsService versionsService = null;
	Versions versions = null;
	
	private  void create() throws Exception{
		versionsService = (VersionsService) DesignTimeServiceFactory.resolve(VersionsService.class);
		versions = new Versions();

		versions.setName("2");
		versions.setId(Sequence.getDesignTimeSequence());
		versions.setType(Versions.TYPE_SOURCECODE_UPGRADE);
		versions.setRemark("这是一个版本测试");
		versions.setUpgrade_date(new Date());
		versions.setVersion_name("1.0测试版本");
		versions.setVersion_number("1.0");
		versionsService.save(versions);
		
	}
	
	private String getFilePeth(Versions app){
		return EnvironmentVariable.WORKSPACE_ROOT_PATH + app.getPath() + "/" + app.getName() + "."
				+ app.getFileSuffix();
	}
	/**
	 * 测试记录obpm版本信息
	 * 1.创建版本文件
	 * 2.解析文件获取节点信息
	 * 3.断言
	 * @throws Exception 
	 */
	@Test
	public void testDoRecordVersions() throws Exception {
		create();
		versionsService.doRecordVersions(versions);
		
	}
	/**
	 * 测试查询obpm版本信息
	 * 1.创建文件
	 * 2.解析xml获取需要的值
	 * 3.通过querByVersionAndType()获取获取对象
	 * 4.断言
	 * @throws Exception 
	 */
	@Test
	public void testQueryByVersionAndType() throws Exception {
		create();
		String name = "2";
		String number = "1.0";
		int type = 1;
		Collection<Versions> n = versionsService.queryByVersionAndType(name, number, type);

		assertEquals("预期和实际的值相同", 1 , n.size());
		
	}
	//遍历多个文件夹
	public List<String> getFilePathList(File file) {
		int count = 0;
	    List<String> filePathList = new ArrayList<String>(); 
	    File[] list = file.listFiles();  
	    if (list != null) {  
	        for (File file2 : list) {  
	            if (file2.isDirectory()) {  
	                filePathList.addAll(getFilePathList(file2));  
	            } else {  
	                filePathList.add(file2.getPath());
					count++;  
	            }  
	        }  
	    }  
	    return filePathList;  
	}  
	
	/**
	 * 测试查询obpm版本信息
	 * 1.创建文件
	 * 2.设置需要的参数
	 * 3.通过queryByType()查询obpm版本
	 * 4.遍历文件获取所在文件的根目录下的所有xml文件
	 * 5.断言
	 * @throws Exception 
	 */
	@Test
	public void testQueryByType() throws Exception {
		create();
		int type = 1;
		Collection<Versions> number = versionsService.queryByType(type);
		//System.out.println(number.size());
		//解析xml文件
		SAXReader reader = new SAXReader();
		VersionsServiceTest rf = new VersionsServiceTest();
		int a = 0;
		//获取当前文件夹下的全部文件
		File file = new File(this.getClass().getClassLoader().getResource("data/workspace").toURI());
		//遍历文件夹
		List<String> list = rf.getFilePathList(file);
		/*** 读取文件夹下所有子目录下的文件，并将其保存到list集合中。*/
		for(int i = 0; i < list.size(); i++){
			//遍历文件获取符合条件的文件
			if(list.get(i).endsWith(".version")){
				//解析实例获取的文件
				File filei = new File(list.get(i)); 
				//读取这个文件，解析xml
				Document doc = reader.read(filei);
				Element root = doc.getRootElement();
				List<Element> ment = root.elements();
				Integer value = 0;
				//迭代xml的节点符合索要条件的xml文件  值
				for(Element e: ment){
						if("type".equals(e.getName())){
							value = Integer.valueOf(e.getStringValue());
						}
				}
				//输出获取到需要判断的节点值
				//符合条件的值使获取到的文件+1
				if ( value == 1) {
					a++;
				}
			
			} 
	
		}
	}
	/**
	 * 测试查找obpm版本信息对象
	 * 
	 * 1.设置需要的参数,创建
	 * 2.通过findCurrVersionByType()获取versionsVo对象
	 * 3.断言
	 * @throws Exception 
	 */
	@Test
	public void testFindCurrVersionByType() throws Exception {
		create();
		int type = 1;
		Versions vo = versionsService.findCurrVersionByType(type);
		//System.out.println(vo.getName());
		
		assertEquals("预期和实际值相同", versions.getName() , vo.getName());
	}
	/**
	 * 测试版本迁移至文件系统
	 * 1.创建文件
	 * 2.通过doUpgrade2FileSystem()
	 * 3.断言
	 * @throws Exception 
	 */
	@Test
	public void testDoUpgrade2FileSystem() throws Exception {
		versionsService = (VersionsService) DesignTimeServiceFactory.resolve(VersionsService.class);
		String a = versionsService.doUpgrade2FileSystem();
		//jsonArray获取json []类型的解析获取 array.getJSONObject(0);
		JSONObject getJson =  new JSONObject(a);//jsonObject获取的是 {}类型的json
		boolean b = getJson.getBoolean("status");
		assertEquals("因为有application所以无法迁移迁移成功", false,b);
	}

}
