package cn.myapps.versions.util;

import cn.myapps.common.Environment;
import cn.myapps.common.model.versions.Versions;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceFactory;
import cn.myapps.upgrade.service.UpgradeService;
import cn.myapps.upgrade.service.UpgradeServiceImpl;
import cn.myapps.util.DateUtil;
import cn.myapps.versions.service.VersionsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.util.Date;

public class VersionsUtil {
	
	private final static Logger LOG = LoggerFactory.getLogger("VersionsUtil");

	public static void doRecord(){
		try {
			Environment evt = Environment.getInstance();
			String applicationRealPath = evt.getApplicationRealPath();
			if(!StringUtil.isBlank(applicationRealPath)){
				String path = "";
				if(applicationRealPath.endsWith("/") || applicationRealPath.endsWith("\\")){
					path = applicationRealPath+ "WEB-INF/timestamp.txt";
				}else {
					path = applicationRealPath+ "/WEB-INF/timestamp.txt";
				}
				File file = new File(path);
				if(file.exists()){
					execute(file);
				}
			}
			
		} catch (Exception e) {
			LOG.error("记录版本发现异常！");
			e.printStackTrace();
		}
	}
	
	private static void execute (File file) throws Exception {
		VersionsService vp = (VersionsService) DesignTimeServiceFactory.resolve(VersionsService.class);
		Versions vo = new Versions();
		BufferedReader breader = null;
		FileInputStream fileIn = new FileInputStream(file);
		Reader reader = new InputStreamReader(fileIn);
		breader = new BufferedReader(reader);
		String line;
		while ((line = breader.readLine()) != null
				&& line.trim().length() > 0) {
			int index = line.indexOf(":");
			String value = line.substring(
					index + 1, line.length())
					.trim();
			if(line.trim().startsWith("打包日期")){
				Date date = new Date();
				try {
					date = DateUtil.parseDateTime(compatibleFormat(value));
				} catch (Exception e) {
					LOG.debug("{}", "打包日期转换异常！The convert date is：" + value);
				}
				vo.setUpgrade_date(date);
			}else if (line.trim().startsWith("Last Changed Rev")){
				vo.setVersion_number(value);
			}else if (line.trim().startsWith("打包版本")){
				vo.setVersion_name(value);
			}
		}
		vo.setType(Versions.TYPE_SOURCECODE_UPGRADE);
		vp.doRecordVersions(vo);
	}
	
	private static String compatibleFormat(String s) throws Exception {
		if(!StringUtil.isBlank(s)){
			if(s.indexOf(" ") > 0){
				if(s.split(":").length == 1){
					s += ":00:00";
				}else if(s.split(":").length == 2){
					s += ":00";
				}
			}else{
				s += " 00:00:00";
			}
		}
		return s;
	}
	
	public static String toHTMLText(){
		StringBuilder html = new StringBuilder();
		try {
			VersionsService vp = (VersionsService) DesignTimeServiceFactory.resolve(VersionsService.class);
			Versions vo = vp.findCurrVersionByType(Versions.TYPE_SOURCECODE_UPGRADE);
			if(vo != null){
				html.append("<font color=\"red\">{*[cn.myapps.core.versions.curr_info]*}：");
				html.append(vo.getVersion_name()).append(" ").append(vo.getVersion_number());
				html.append("</font>");
			}else{
				html.append("<font color=\"red\">{*[cn.myapps.core.versions.not.find]*}!</font>");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return html.toString();
	}
	
	/**
	 * 是否满足迁移条件
	 * @return
	 */
	public static boolean isUpgradeEnable(){
		boolean isUpgrade = false;
		try {
			UpgradeService ugs = new UpgradeServiceImpl();
			isUpgrade = ugs.isUpGradeEnable();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return isUpgrade;
		
	}
	
}
