package cn.myapps.versions.service;

import cn.myapps.common.DesignTimeService;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.model.versions.Versions;

import java.util.Collection;


public interface VersionsService  extends DesignTimeService<Versions> {
	
	/**
	 * 记录obpm版本信息
	 * @param vo
	 * @throws Exception
	 */
	public void doRecordVersions(Versions vo) throws Exception;

	/**
	 * 查询obpm版本信息
	 * @param name 版本名称(如：R2.5-sp8)
	 * @param number 版本号(如：16913)
	 * @param type 升级类型 	1：程序(源码)升级
	 * @return
	 * @throws Exception
	 */
	public Collection<Versions> queryByVersionAndType(String name, String number, int type) throws Exception;
	
	/**
	 * 查询obpm版本信息
	 * @param type 升级类型 	1：程序(源码)升级   2：数据升级
	 * @return
	 * @throws Exception
	 */
	public Collection<Versions> queryByType(int type) throws Exception;
	
	/**
	 * 查找obpm版本信息
	 * @param type 升级类型 	1：程序(源码)升级   2：数据升级
	 * @return
	 * @throws Exception
	 */
	public Versions findCurrVersionByType(int type) throws Exception;

	
	/**
	 * 版本迁移至文件系统
	 * {
	 * 	 "status" : 迁移是否成功 ： true / false
	 *   "message"：  迁移提示信息  
	 *        
	 *        2000 : 迁移成功
	 *        4001 : workspace下已经存在数据
	 *        4002 : 存在脏数据，无法迁移
	 *        
	 *   "datas":   具体数字信息
	 * }
	 * 
	 * @return 
	 */
	public String doUpgrade2FileSystem()throws Exception;
	
	
	/**
	 * 迁移数据格式
	 * 之前docid为uuid，4.5版本后需要用原docid + @ + formid
	 * @return
	 * @throws Exception
	 */
	public String doUpgradeData()throws Exception;

	/**
	 * 清空文件系统
	 * {
	 * 	 "status" : 迁移是否成功 ： true / false
	 *   "message"：  迁移提示信息  
	 *        
	 *        2000 : 迁移成功
	 *        4001 : workspace下已经存在数据
	 *        4002 : 存在脏数据，无法迁移
	 *        
	 *   "datas":   具体数字信息
	 * }
	 * 
	 * @return 
	 */
	public String doClearFileSystem()throws Exception;


	public boolean isUpgradeSuccess()throws Exception;

	public DataPackage<Versions> query(String parentId, String name, Integer type , int page, int lines) throws Exception;
}
