package cn.myapps.upgrade.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.myapps.common.util.DbUtil;
import cn.myapps.upgrade.util.ConnectionManager;


public class MsSqlUpgradeDAO extends AbstractUpgradeDao implements UpgradeDao {
	
	public MsSqlUpgradeDAO(Connection conn) throws Exception {
		super(conn);
		dbTag = "MS SQL SERVER: ";
		this.schema = DbUtil.getSchema(conn, DbUtil.DBTYPE_MSSQL);
	}

	@Override
	public void DeleteForeignFromUserDepartmentSetAndUserRoleSet() throws Exception {
		List<Map<String,String>> lists=new ArrayList<Map<String,String>>();
		Connection conn=null;
		PreparedStatement stmt=null;
		ResultSet rs =null;

		Map<String,String> maps=new HashMap<String,String>();
		try {
			conn= ConnectionManager.getConnection();
			String sql="SELECT *,OBJECT_NAME(A.PARENT_OBJECT_ID) TABLENAME1 FROM SYS.FOREIGN_KEYS A WHERE A.REFERENCED_OBJECT_ID=OBJECT_ID('T_USER') AND OBJECT_NAME(A.PARENT_OBJECT_ID) IN ('T_USER_DEPARTMENT_SET','T_USER_ROLE_SET')";
			stmt=conn.prepareStatement(sql);
			rs = stmt.executeQuery();
			//防止此表有多个外键
			while(rs.next()) {
				maps=new HashMap<String,String>();
				maps.put(rs.getString("tablename1"), rs.getString("name"));
				lists.add(maps);
			}
			System.out.println(lists);

			for (Map<String, String> map : lists) {
				//删除外键：
				for (String key:map.keySet()) {
					PreparedStatement deleteForeignPs = null;
					try {
						String deleteForeign = "ALTER TABLE "+key+" DROP CONSTRAINT "+map.get(key);
						deleteForeignPs = conn.prepareStatement(deleteForeign);
						deleteForeignPs.executeUpdate();
					} catch (Exception e) {
						e.printStackTrace();
					}finally{
						if(deleteForeignPs!=null) deleteForeignPs.close();
					}
				}
			}
		} catch(Exception e) {
			e.printStackTrace();
		}finally{
			ConnectionManager.closeStatement(stmt);
			if(rs!=null) rs.close();
			if(conn!=null) conn.close();
		}
	}
}
