package cn.myapps.run;

import javax.swing.SwingUtilities;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;

import cn.myapps.upgrade.gui.Launcher;

@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class, JpaRepositoriesAutoConfiguration.class })
//@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class })
//@SpringBootApplication
@ComponentScan(basePackages = { "cn.myapps.conf", "cn.myapps.run", "cn.myapps.common.util",
//		"cn.myapps.runtime.rest.security.service",
		"cn.myapps.util", "cn.myapps.base.web",
//		"cn.myapps.runtime.common.utils",
		"cn.myapps.**.service", "cn.myapps.common.exception", "cn.myapps.**.dao", "cn.myapps.designtime.report",
		"cn.myapps.runtime.workflow.analyzer" })
public class Start {
	public static int STATUS = 0; 

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			@Override
			public void run() {
				try {
					new Launcher();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		SpringApplication.run(Start.class, args);
	}

}
