package cn.myapps.run;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class, JpaRepositoriesAutoConfiguration.class})
//@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class })
//@SpringBootApplication
@EnableFeignClients(basePackages = {"cn.myapps.conf","cn.myapps.runtime.common.feign.service"})
@ComponentScan(basePackages = { "cn.myapps.run", "cn.myapps.conf", "cn.myapps.common.util","cn.myapps.runtime.rest.security.service",
		"cn.myapps.util", "cn.myapps.base.web", "cn.myapps.runtime.common.utils", 
		"cn.myapps.runtime.excutor.async", "cn.myapps.**.action","cn.myapps.**.log.aspect",
		"cn.myapps.**.controller", "com.teemlink.**.controller", "com.teemlink.**.service","cn.myapps.**.service",
		"cn.myapps.**.action", "com.teemlink.km", "cn.myapps.common.exception" ,"cn.myapps.**.dao","cn.myapps.designtime.report","cn.myapps.runtime.workflow.analyzer","com.jgqz","cn.myapps.runtime.dynaform.document.ejb"
		, "cn.myapps.scheduler"	})
public class RuntimeWithWar  extends SpringBootServletInitializer {

    public static void main(String[] args) {
    	try {
            SpringApplication.run(RuntimeWithWar.class, args);			
		} catch (Exception e) {
			e.printStackTrace();
		}
    }

    @Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.sources(RuntimeWithWar.class);
    }
}
