package cn.myapps.run;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;

@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class, JpaRepositoriesAutoConfiguration.class })
//@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class })
//@SpringBootApplication
@ComponentScan(basePackages = { "cn.myapps.conf", "cn.myapps.common.util", "cn.myapps.runtime.rest.security.service",
		"cn.myapps.util", "cn.myapps.base.web", "cn.myapps.runtime.common.utils", "cn.myapps.runtime.excutor.async",
		"cn.myapps.**.action", "cn.myapps.**.controller","com.teemlink.**.service", "com.teemlink.**.controller", "cn.myapps.**.service",
		"cn.myapps.**.action", "com.teemlink.km", "cn.myapps.common.exception", "cn.myapps.**.dao",
		"cn.myapps.designtime.report", "cn.myapps.runtime.workflow.analyzer", "com.jgqz",
		"cn.myapps.runtime.dynaform.document.ejb","cn.myapps.**.log.aspect", "cn.myapps.scheduler" })

//开启Feign客户端
@Import({FeignAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class})
@EnableFeignClients(basePackages = {"cn.myapps.conf","cn.myapps.runtime.common.feign.service"})
@EnableAutoConfiguration
@EnableDiscoveryClient
public class RuntimeWithNacosApp {

	public static void main(String[] args) {
		try{

		SpringApplication.run(RuntimeWithNacosApp.class, args);
		}catch(Exception e){
			e.printStackTrace();
		}
	}
}
