package cn.myapps.run;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class, JpaRepositoriesAutoConfiguration.class})
@ComponentScan(basePackages = { "cn.myapps.conf", "cn.myapps.common.util","cn.myapps.runtime.rest.security.service",
		"cn.myapps.util", "cn.myapps.base.web", "cn.myapps.runtime.common.utils", "cn.myapps.runtime.excutor.async", "cn.myapps.**.action",
		"cn.myapps.**.controller", "com.teemlink.**.controller","com.teemlink.**.service", "cn.myapps.**.service",
		"cn.myapps.**.action", "com.teemlink.km", "cn.myapps.common.exception" ,"cn.myapps.**.dao","cn.myapps.designtime.report","cn.myapps.runtime.workflow.analyzer","com.jgqz","cn.myapps.runtime.dynaform.document.ejb","cn.myapps.scheduler"})
public class RuntimeWithEurekaApp {

	public static void main(String[] args) {
		SpringApplication.run(RuntimeWithEurekaApp.class, args);
	}

}
