/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.message.controller;

import cn.myapps.AbstractRuntimeController;
import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.message.service.MessageRunTimeService;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u6d88\u606f\u4e2d\u5fc3\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/runtime/messages"}, produces={"application/json;charset=UTF-8"})
public class MessageController
extends AbstractRuntimeController {
    @Autowired
    private MessageRunTimeService messageService;

    @GetMapping(value={"/notices"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u8fd0\u884c\u6267\u884c\u524d\u811a\u672c", notes="\u8fd0\u884c\u6267\u884c\u524d\u811a\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="\u5f53\u524d\u9875", required=false, paramType="query", dataType="int", defaultValue="1"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u663e\u793a\u6761\u6570", required=false, paramType="query", dataType="int", defaultValue="10")})
    public Resource getNotices(@RequestParam(required=false, defaultValue="1") Integer pageNo, @RequestParam(required=false, defaultValue="10") Integer linesPerPage) throws Exception {
        Map<String, Object> result = this.messageService.getNotices(this.getUser().getId(), pageNo, linesPerPage);
        return this.success("ok", result);
    }

    @PutMapping(value={"/notices/{id}/read"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6807\u8bb0\u5df2\u8bfb", notes="\u6807\u8bb0\u5df2\u8bfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u901a\u77e5id", required=true, paramType="path", dataType="string")})
    public Resource set2Read(@PathVariable String id) throws Exception {
        this.messageService.set2Read(id);
        return this.success("ok", null);
    }

    @PutMapping(value={"/notices/read"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6807\u8bb0\u5168\u90e8\u5df2\u8bfb", notes="\u6807\u8bb0\u5168\u90e8\u5df2\u8bfb")
    public Resource setAll2Read() throws Exception {
        this.messageService.setAll2Read(this.getUser().getId());
        return this.success("ok", null);
    }

    @DeleteMapping(value={"/notices/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u901a\u77e5\uff08\u53ef\u6279\u91cf)", notes="\u5220\u9664\u901a\u77e5\uff08\u53ef\u6279\u91cf)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource delete(@RequestBody String content) throws Exception {
        List ids = (List)JsonPath.parse((String)content).json();
        String[] idArray = new String[]{};
        idArray = ids.toArray(idArray);
        this.messageService.delete(idArray);
        return this.success("ok", null);
    }
}

