/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.util.sequence;

import cn.myapps.common.util.SequenceGenerator;
import java.util.HashMap;
import java.util.Map;

public class Sequence
extends SequenceGenerator {
    private static final int MAX_DEPTS_PER_LEVEL = 100;
    private static final int MAX_GROUP_PER_LEVEL = 100;
    private static final int MAX_PERSONS_PER_LEVEL = 1000;
    private static long counter = 0L;
    public static final int MAX_TOPIC_NUMBER = 1000000;
    public static final int MAX_TOPICCHILD_NUMBER = 1000;
    public static final int MAX_TITLE_COUNT = 10000;
    public static final int MAX_SHORTMESSAGE_NUMBER = 9999;
    private static char[] HandlerChars = new char[]{'A', 'B', 'C'};
    private static char baseChar = (char)65;
    private static final char maxChar = 'Z';
    private static Object obj = new Object();

    static class Numbers {
        static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        static final Map<Character, Integer> digitMap = new HashMap<Character, Integer>();
        public static final int MAX_RADIX;
        public static final int MIN_RADIX = 2;

        Numbers() {
        }

        public static String toString(long i, int radix) {
            boolean negative;
            if (radix < 2 || radix > MAX_RADIX) {
                radix = 10;
            }
            if (radix == 10) {
                return Long.toString(i);
            }
            int size = 65;
            int charPos = 64;
            char[] buf = new char[65];
            boolean bl = negative = i < 0L;
            if (!negative) {
                i = -i;
            }
            while (i <= (long)(-radix)) {
                buf[charPos--] = digits[(int)(-(i % (long)radix))];
                i /= (long)radix;
            }
            buf[charPos] = digits[(int)(-i)];
            if (negative) {
                buf[--charPos] = 45;
            }
            return new String(buf, charPos, 65 - charPos);
        }

        static NumberFormatException forInputString(String s) {
            return new NumberFormatException("For input string: \"" + s + "\"");
        }

        public static long toNumber(String s, int radix) {
            if (s == null) {
                throw new NumberFormatException("null");
            }
            if (radix < 2) {
                throw new NumberFormatException("radix " + radix + " less than Numbers.MIN_RADIX");
            }
            if (radix > MAX_RADIX) {
                throw new NumberFormatException("radix " + radix + " greater than Numbers.MAX_RADIX");
            }
            long result = 0L;
            boolean negative = false;
            int i = 0;
            int len = s.length();
            long limit = -9223372036854775807L;
            if (len > 0) {
                char firstChar = s.charAt(0);
                if (firstChar < '0') {
                    if (firstChar == '-') {
                        negative = true;
                        limit = Long.MIN_VALUE;
                    } else if (firstChar != '+') {
                        throw Numbers.forInputString(s);
                    }
                    if (len == 1) {
                        throw Numbers.forInputString(s);
                    }
                    ++i;
                }
                long multmin = limit / (long)radix;
                while (i < len) {
                    Integer digit;
                    if ((digit = digitMap.get(Character.valueOf(s.charAt(i++)))) == null) {
                        throw Numbers.forInputString(s);
                    }
                    if (digit < 0) {
                        throw Numbers.forInputString(s);
                    }
                    if (result < multmin) {
                        throw Numbers.forInputString(s);
                    }
                    if ((result *= (long)radix) < limit + (long)digit.intValue()) {
                        throw Numbers.forInputString(s);
                    }
                    result -= (long)digit.intValue();
                }
            } else {
                throw Numbers.forInputString(s);
            }
            return negative ? result : -result;
        }

        static {
            for (int i = 0; i < digits.length; ++i) {
                digitMap.put(Character.valueOf(digits[i]), i);
            }
            MAX_RADIX = digits.length;
        }
    }
}

