/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.notification.service;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.conf.UserAPI;
import cn.myapps.message.base.service.BaseProcess;
import cn.myapps.message.comment.dao.CommentDAO;
import cn.myapps.message.comment.model.Comment;
import cn.myapps.message.message.model.Message;
import cn.myapps.message.notice.dao.NoticeDAO;
import cn.myapps.message.notice.model.Notice;
import cn.myapps.message.notification.dao.NotificationDAO;
import cn.myapps.message.notification.model.Notification;
import cn.myapps.message.notification.service.NotificationProcess;
import cn.myapps.message.util.sequence.Sequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class NotificationProcessBean
implements BaseProcess<Notification>,
NotificationProcess {
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private NoticeDAO noticeDAO;
    @Autowired
    private CommentDAO commentDAO;

    @Override
    public void doCreateMessagesNotification(Message message, String domainid, IUser user) throws Exception {
        if (message != null) {
            ArrayList<Notification> notifications = null;
            if (message.getType() != 0) {
                if (message.getType() == 1) {
                    String receiverId = message.getReceiverId();
                    if (message.getScope() == 0) {
                        UserAPI userAPI = (UserAPI)SpringApplicationContextUtil.getBean(UserAPI.class);
                        Collection departmentUsers = userAPI.getDomainUsers(domainid);
                        JSONArray array = JSONArray.fromObject((Object)departmentUsers);
                        notifications = new ArrayList();
                        for (Object object : array) {
                            JSONObject json = JSONObject.fromObject(object);
                            Notification notice = new Notification();
                            notice.setId(Sequence.getSequence());
                            String linkParams = null;
                            notice.setSummary(message.getTitle());
                            notice.setLinkParams(linkParams);
                            notice.setMessageId(message.getId());
                            notice.setMessageType(1);
                            notice.setModule("message");
                            notice.setSender(message.getSender());
                            notice.setSenderId(message.getSenderId());
                            notice.setReceiverId((String)json.get("id"));
                            notice.setDomainid(domainid);
                            notice.setCreateTime(new Date());
                            notifications.add(notice);
                        }
                    } else if (message.getScope() == 2 && !StringUtil.isBlank((String)receiverId)) {
                        notifications = new ArrayList<Notification>();
                        for (String userId : receiverId.split(",")) {
                            Notification notice = new Notification();
                            notice.setId(Sequence.getSequence());
                            String linkParams = null;
                            notice.setSummary(message.getTitle());
                            notice.setLinkParams(linkParams);
                            notice.setMessageId(message.getId());
                            notice.setMessageType(1);
                            notice.setModule("message");
                            notice.setSender(message.getSender());
                            notice.setSenderId(message.getSenderId());
                            notice.setReceiverId(userId);
                            notice.setDomainid(domainid);
                            notice.setCreateTime(new Date());
                            notifications.add(notice);
                        }
                    }
                } else if (message.getType() == 2) {
                    // empty if block
                }
            }
            if (notifications != null) {
                this.notificationDAO.saveAll(notifications);
            }
        }
    }

    @Override
    public void doCreateCommentNotification(Comment comment, String domainId, IUser user) throws Exception {
        if (comment != null) {
            Notification notice = new Notification();
            notice.setId(Sequence.getSequence());
            String linkParams = null;
            notice.setSummary(comment.getContent());
            notice.setLinkParams(linkParams);
            notice.setMessageId(comment.getMessageId());
            notice.setMessageType(2);
            notice.setModule("message");
            notice.setReceiverId(comment.getToUserId());
            notice.setSender(comment.getSender());
            notice.setSenderId(comment.getSenderId());
            notice.setCreateTime(new Date());
            notice.setDomainid(domainId);
            this.notificationDAO.save(notice);
        }
    }

    @Override
    public void doCreateNoticeNotification(Notice notice, String domainId, IUser user) throws Exception {
        if (notice != null) {
            Notification notification = new Notification();
            notification.setId(Sequence.getSequence());
            notification.setLinkParams(notice.getLinkParams());
            notification.setMessageId(notice.getId());
            notification.setMessageType(3);
            notification.setModule(notice.getModule());
            notification.setReceiverId(notice.getToUserId());
            notification.setSummary(notice.getSummary());
            notification.setDomainid(domainId);
            notification.setSender(user.getName());
            notification.setSenderId(user.getId());
            notification.setCreateTime(notice.getCreateTime());
            this.notificationDAO.save(notification);
        }
    }

    @Override
    public JSONObject sendMessageNotification2User(final String userId) throws Exception {
        JSONObject result = new JSONObject();
        Collection<Notification> notifications = null;
        notifications = this.notificationDAO.queryNotificationsByTimer(userId);
        this.notificationDAO.deleteAllByReceiverId(userId);
        Specification<Notice> noticeSpecification = new Specification<Notice>(){

            public Predicate toPredicate(Root<Notice> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (StringUtil.isBlank((String)userId)) {
                    predicates.add(cb.equal((Expression)root.get("toUserId"), (Object)userId));
                }
                predicates.add(cb.equal((Expression)root.get("read"), (Object)1));
                Predicate[] pre = new Predicate[predicates.size()];
                query.where(predicates.toArray(pre));
                return cb.and(predicates.toArray(pre));
            }
        };
        Specification<Comment> commentSpecification = new Specification<Comment>(){

            public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (StringUtil.isBlank((String)userId)) {
                    predicates.add(cb.equal((Expression)root.get("toUserId"), (Object)userId));
                }
                predicates.add(cb.equal((Expression)root.get("read"), (Object)1));
                Predicate[] pre = new Predicate[predicates.size()];
                query.where(predicates.toArray(pre));
                return cb.and(predicates.toArray(pre));
            }
        };
        result.put((Object)"data", notifications);
        JSONObject amount = new JSONObject();
        int notice = (int)this.noticeDAO.count((Specification)noticeSpecification);
        int comment = (int)this.commentDAO.count((Specification)commentSpecification);
        amount.put((Object)"notice", (Object)notice);
        amount.put((Object)"comment", (Object)comment);
        amount.put((Object)"sum", (Object)(comment + notice));
        result.put((Object)"amount", (Object)amount);
        return result;
    }

    @Override
    public JSONObject sendMessageNotificationWhenLogin(final String userId) throws Exception {
        JSONObject result = new JSONObject();
        Object notifications = null;
        List list = this.notificationDAO.queryNotificationCountByReceiverIdGroupByMessageType(userId);
        int rowCount = 0;
        for (Object row : list) {
            Object[] cells = (Object[])row;
            int type = (Integer)cells[0];
            if (3 == type || 2 == type) continue;
            int nums = (Integer)cells[1];
            rowCount += nums;
            result.put((Object)type, (Object)nums);
        }
        this.notificationDAO.deleteAllByReceiverId(userId);
        Specification<Notice> noticeSpecification = new Specification<Notice>(){

            public Predicate toPredicate(Root<Notice> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (!StringUtil.isBlank((String)userId)) {
                    predicates.add(cb.equal((Expression)root.get("toUserId"), (Object)userId));
                }
                predicates.add(cb.equal((Expression)root.get("read"), (Object)0));
                Predicate[] pre = new Predicate[predicates.size()];
                query.where(predicates.toArray(pre));
                return cb.and(predicates.toArray(pre));
            }
        };
        Specification<Comment> commentSpecification = new Specification<Comment>(){

            public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (!StringUtil.isBlank((String)userId)) {
                    predicates.add(cb.equal((Expression)root.get("toUserId"), (Object)userId));
                }
                predicates.add(cb.equal((Expression)root.get("read"), (Object)0));
                Predicate[] pre = new Predicate[predicates.size()];
                query.where(predicates.toArray(pre));
                return cb.and(predicates.toArray(pre));
            }
        };
        int notice = (int)this.noticeDAO.count((Specification)noticeSpecification);
        int comment = (int)this.commentDAO.count((Specification)commentSpecification);
        result.put((Object)3, (Object)notice);
        result.put((Object)2, (Object)comment);
        result.put((Object)"size", (Object)(rowCount + notice + comment));
        return result;
    }

    @Override
    public void clearMessageNotification(final Integer type, final String messageId, Boolean isSend, final String userId) throws Exception {
        Specification<Notification> specification = new Specification<Notification>(){

            public Predicate toPredicate(Root<Notification> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (userId != null && !userId.equals("")) {
                    predicates.add(cb.equal((Expression)root.get("receiverId"), (Object)userId));
                }
                if (type != null) {
                    predicates.add(cb.equal((Expression)root.get("messageType"), (Object)Integer.toString(type)));
                }
                if (!StringUtil.isBlank((String)messageId)) {
                    predicates.add(cb.equal((Expression)root.get("messageId"), (Object)messageId));
                }
                Predicate[] pre = new Predicate[predicates.size()];
                query.where(predicates.toArray(pre));
                return cb.and(predicates.toArray(pre));
            }
        };
        List all = this.notificationDAO.findAll((Specification)specification);
        this.notificationDAO.deleteInBatch(all);
    }

    @Override
    public JSONObject getNotificationCount(final String userId) throws Exception {
        JSONObject result = new JSONObject();
        int notice = 0;
        int comment = 0;
        if (StringUtils.hasLength((String)userId)) {
            Specification<Notice> noticeSpecification = new Specification<Notice>(){

                public Predicate toPredicate(Root<Notice> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                    ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                    if (!StringUtil.isBlank((String)userId)) {
                        predicates.add(cb.equal((Expression)root.get("toUserId"), (Object)userId));
                    }
                    predicates.add(cb.equal((Expression)root.get("read"), (Object)0));
                    Predicate[] pre = new Predicate[predicates.size()];
                    query.where(predicates.toArray(pre));
                    return cb.and(predicates.toArray(pre));
                }
            };
            Specification<Comment> commentSpecification = new Specification<Comment>(){

                public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                    ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                    if (!StringUtil.isBlank((String)userId)) {
                        predicates.add(cb.equal((Expression)root.get("toUserId"), (Object)userId));
                    }
                    predicates.add(cb.equal((Expression)root.get("read"), (Object)0));
                    Predicate[] pre = new Predicate[predicates.size()];
                    query.where(predicates.toArray(pre));
                    return cb.and(predicates.toArray(pre));
                }
            };
            notice = (int)this.noticeDAO.count((Specification)noticeSpecification);
            comment = (int)this.commentDAO.count((Specification)commentSpecification);
        }
        result.put((Object)"notice", (Object)notice);
        result.put((Object)"comment", (Object)comment);
        result.put((Object)"sum", (Object)(notice + comment));
        return result;
    }

    @Override
    public void doCreateNotification4PerssonalMessage(Message message, String domainid, IUser user) throws Exception {
        if (message != null) {
            ArrayList<Notification> notifications = null;
            notifications = new ArrayList<Notification>();
            String receiverId = message.getReceiverId();
            for (String userId : receiverId.split(",")) {
                Notification notice = new Notification();
                notice.setId(Sequence.getSequence());
                String linkParams = null;
                notice.setSummary(message.getTitle() + ":" + message.getContent());
                notice.setLinkParams(linkParams);
                notice.setMessageId(message.getId());
                notice.setMessageType(0);
                notice.setModule("message");
                notice.setSender(message.getSender());
                notice.setSenderId(message.getSenderId());
                notice.setReceiverId(userId);
                notice.setDomainid(domainid);
                notice.setCreateTime(new Date());
                notifications.add(notice);
            }
            if (notifications != null) {
                this.notificationDAO.saveAll(notifications);
            }
        }
    }

    @Override
    public AuthtimeValueObject doCreate(AuthtimeValueObject vo) throws Exception {
        return null;
    }

    @Override
    public AuthtimeValueObject doUpdate(AuthtimeValueObject vo) throws Exception {
        return null;
    }

    @Override
    public AuthtimeValueObject doView(String pk) throws Exception {
        return null;
    }

    @Override
    public void doRemove(String pk) throws Exception {
    }

    @Override
    public void doRemove(String[] pk) throws Exception {
    }

    @Override
    public DataPackage<Notification> doQuery(ParamsTable params, IUser user) throws Exception {
        return null;
    }
}

