/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.message.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.FileWriteUtil;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.conf.FeignConfig;
import cn.myapps.message.base.controller.BaseController;
import cn.myapps.message.comment.model.Comment;
import cn.myapps.message.comment.service.CommentProcess;
import cn.myapps.message.comment.service.CommentProcessBean;
import cn.myapps.message.message.model.Message;
import cn.myapps.message.message.service.MessageProcess;
import cn.myapps.message.message.service.MessageProcessBean;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="MessageAction")
@RequestMapping(value={"/api/message/messages"})
@Scope(value="prototype")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@Api(tags={"\u6d88\u606f\u6a21\u5757"})
public class MessageController
extends BaseController<Message> {
    @Autowired
    private CommentProcess commentProcess;
    @Autowired
    private MessageProcess messageProcess;
    @Autowired
    private DistributedCacheProvider distributedCacheProvider;

    public MessageController() {
        this.content = new Message();
        this.process = new MessageProcessBean();
    }

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u6d88\u606f\u4ee5\u53ca\u8bc4\u8bba\u5185\u5bb9", notes="\u83b7\u53d6\u6d88\u606f\u4ee5\u53ca\u8bc4\u8bba\u5185\u5bb9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="messageId", value="\u6d88\u606fid", required=true, paramType="query", dataType="string")})
    public Map<String, Object> doGetMessage() {
        try {
            WebUser user = this.getUser();
            ParamsTable params = this.getParams();
            String messageId = params.getParameterAsString("messageId");
            Message message = this.messageProcess.doView(messageId);
            CommentProcessBean cp = new CommentProcessBean();
            DataPackage<Comment> comments = this.commentProcess.queryComments4Message(messageId, 1, 100, user);
            JSONObject result = new JSONObject();
            result.put((Object)"message", (Object)message);
            result.put((Object)"comments", comments);
            return this.addActionResult(true, "", result);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @PostMapping
    @ApiOperation(value="\u53d1\u5e03\u6d88\u606f", notes="\u53d1\u5e03\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Map<String, Object> doPublicMessage() {
        try {
            WebUser user = this.getUser();
            Message message = (Message)this.getContent();
            ParamsTable params = this.getParams();
            message.setContent(params.getParameterAsString("content.content"));
            message.setAttachment(params.getParameterAsString("content.attachment"));
            message.setScope(params.getParameterAsInteger("content.scope"));
            message.setType(params.getParameterAsInteger("content.type"));
            message = this.messageProcess.doPublicMessage(params, message, user);
            return this.addActionResult(true, "\u53d1\u5e03\u6210\u529f", message);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @PostMapping(value={"/announcement"})
    @ApiOperation(value="\u53d1\u5e03\u516c\u544a", notes="\u53d1\u5e03\u516c\u544a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Map<String, Object> doPublicAnnouncement() {
        try {
            WebUser user = this.getUser();
            Message message = (Message)this.getContent();
            ParamsTable params = this.getParams();
            message.setTitle(params.getParameterAsString("content.title"));
            message.setCategory(params.getParameterAsString("content.category"));
            message.setContent(params.getParameterAsString("content.content"));
            message.setScope(params.getParameterAsInteger("content.scope"));
            message.setType(params.getParameterAsInteger("content.type"));
            message.setSticky(Boolean.valueOf(params.getParameterAsString("content.sticky")));
            message = this.messageProcess.doPublicAnnouncement(params, message, user);
            return this.addActionResult(true, "\u53d1\u5e03\u6210\u529f", message);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u53d1\u5e03\u516c\u544a", notes="\u53d1\u5e03\u516c\u544a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="receiverids", value="\u63a5\u6536\u4eba", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="title", value="\u6807\u9898", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="content", value="\u5185\u5bb9", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="userId", value="\u53d1\u9001\u7528\u6237", required=false, paramType="query", dataType="string")})
    public void doCreateMessage(String receiverids, String title, String content, String userId) throws Exception {
        if (StringUtils.isEmpty((String)FeignConfig.ACCESS_TOKEN)) {
            FeignConfig.ACCESS_TOKEN = Security.getToken((String)userId);
        }
        this.messageProcess.doCreateMessage(receiverids, title, content, userId);
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u4fe1\u606f", notes="\u5220\u9664\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u5e94\u7528id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="messageId", value="\u6d88\u606fid", required=true, paramType="query", dataType="string")})
    public Map<String, Object> doDelete(@RequestParam String messageId) {
        try {
            ParamsTable params = this.getParams();
            String applicationId = params.getParameterAsString("applicationId");
            this.messageProcess.doDeleteMessageAndNotification(messageId, applicationId);
            return this.addActionResult(true, "\u5220\u9664\u6210\u529f", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u6d88\u606f\u5217\u8868\u67e5\u8be2(\u5305\u542b\u6761\u4ef6) ", notes="\u67e5\u8be2\u6d88\u606f\u5217\u8868\u67e5\u8be2(\u5305\u542b\u6761\u4ef6) ")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="_currpage", value="\u9875\u957f\u5ea6", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="_rowcount", value="\u5f53\u524d\u9875\u7801", required=false, paramType="query", dataType="string")})
    public Map<String, Object> doQuery4Message() {
        try {
            ParamsTable params = this.getParams();
            String content = params.getParameterAsString("content");
            Integer page = params.getParameterAsInteger("_currpage");
            Integer lines = params.getParameterAsInteger("_rowcount");
            if (page == null || page <= 0) {
                page = 1;
            }
            if (lines == null || lines <= 0) {
                lines = 30;
            }
            WebUser user = this.getUser();
            Integer finalPage = page;
            Integer finalLines = lines;
            DataPackage<Message> data = null;
            data = this.messageProcess.queryMessages(content, finalPage, finalLines, user);
            return this.addActionResult(true, "", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/announcement"})
    @ApiOperation(value="\u516c\u544a\u578b\u6d88\u606f\u5217\u8868(\u5305\u542b\u6761\u4ef6) ", notes="\u516c\u544a\u578b\u6d88\u606f\u5217\u8868(\u5305\u542b\u6761\u4ef6) ")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="_currpage", value="\u9875\u957f\u5ea6", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="_rowcount", value="\u5f53\u524d\u9875\u7801", required=false, paramType="query", dataType="string")})
    public Map<String, Object> doQuery4Announcement() {
        try {
            ParamsTable params = this.getParams();
            String content = params.getParameterAsString("content");
            Integer page = params.getParameterAsInteger("_currpage");
            Integer lines = params.getParameterAsInteger("_rowcount");
            if (page == null || page <= 0) {
                page = 1;
            }
            if (lines == null || lines <= 0) {
                lines = 30;
            }
            WebUser user = this.getUser();
            String cacheKey = String.format("doQuery4Announcement:%s-%s-%s", user.getId(), page, content);
            Integer finalPage = page;
            Integer finalLines = lines;
            DataPackage data = (DataPackage)this.distributedCacheProvider.get(cacheKey, () -> {
                try {
                    return this.messageProcess.queryMessage4Announcement(content, finalPage, finalLines, user);
                }
                catch (Exception e) {
                    return null;
                }
            }, 300L);
            return this.addActionResult(true, "", data);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/attachement/preview"})
    @ApiOperation(value="\u67e5\u770b\u9884\u89c8\u6587\u4ef6", notes="\u67e5\u770b\u9884\u89c8\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6587\u4ef6id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="extName", value="\u540e\u7f00\u540d", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="url", value="\u6587\u4ef6\u8def\u5f84", required=true, paramType="query", dataType="string")})
    public Map<String, Object> doView4Attachement() throws Exception {
        ParamsTable params = this.getParams();
        String id = params.getParameterAsString("id");
        String extName = params.getParameterAsString("extName");
        String url = params.getParameterAsString("url");
        HashMap<String, String> info = new HashMap<String, String>();
        try {
            if (!(StringUtil.isBlank((String)url) || StringUtil.isBlank((String)extName) || StringUtil.isBlank((String)id))) {
                String realPath = PropertyUtil.getPath() + "/workspace";
                String origPath = realPath + url;
                String swfPath = realPath + url.substring(0, url.indexOf(id)) + "/swf/" + id + ".swf";
                File origFile = new File(origPath);
                File swfFile = new File(swfPath);
                if (origFile.exists()) {
                    info.put("origPath", origPath);
                    if (swfFile.exists()) {
                        info.put("swfPath", swfPath);
                        info.put("is2SWF", "true");
                    } else {
                        try {
                            String rootPath = PropertyUtil.getPath();
                            FileWriteUtil.writeKmConvertTask((String)rootPath, (String)id, (String)origFile.getPath());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        info.put("swfPath", swfPath);
                        info.put("is2SWF", "false");
                    }
                } else {
                    info.put("origPath", "");
                    info.put("swfPath", "");
                    info.put("is2SWF", "false");
                }
            } else {
                info.put("origPath", "");
                info.put("swfPath", "");
                info.put("is2SWF", "false");
            }
            return this.addActionResult(true, "", info);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }
}

