/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.comment.service;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.StringUtil;
import cn.myapps.message.base.service.BaseProcess;
import cn.myapps.message.comment.dao.CommentDAO;
import cn.myapps.message.comment.model.Comment;
import cn.myapps.message.comment.service.CommentProcess;
import cn.myapps.message.message.dao.MessageDAO;
import cn.myapps.message.message.model.Message;
import cn.myapps.message.notification.dao.NotificationDAO;
import cn.myapps.message.notification.service.NotificationProcess;
import cn.myapps.message.util.sequence.Sequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CommentProcessBean
implements BaseProcess<Comment>,
CommentProcess {
    @Autowired
    private CommentDAO commentDAO;
    @Autowired
    private MessageDAO messageDAO;
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private NotificationProcess notificationProcess;

    @Override
    public Comment doComment(ParamsTable params, Comment vo, IUser user) throws Exception {
        Comment comment = null;
        try {
            String domainId = user.getDomainid();
            String toContent = params.getParameterAsString("toContent");
            if (vo != null) {
                vo.setId(Sequence.getSequence());
                vo.setDomainid(domainId);
                vo.setCreateTime(new Date());
                vo.setSender(user.getName());
                vo.setSenderId(user.getId());
                vo.setToContent(toContent);
                vo.setRead(false);
                String module = null;
                vo.setModule(module);
                comment = (Comment)this.commentDAO.save(vo);
                this.messageDAO.Updatecomment_count(vo.getMessageId());
                try {
                    this.notificationProcess.doCreateCommentNotification(comment, domainId, user);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return comment;
    }

    @Override
    public void doDeleteCommon(String commentId, final String messageId, String domainId) throws Exception {
        try {
            this.commentDAO.deleteById(commentId);
            Specification<Comment> specification = new Specification<Comment>(){

                public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                    ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                    if (messageId != null && !messageId.equals("")) {
                        predicates.add(cb.equal((Expression)root.get("messageId"), (Object)messageId));
                    }
                    Predicate[] pre = new Predicate[predicates.size()];
                    query.where(predicates.toArray(pre));
                    return cb.and(predicates.toArray(pre));
                }
            };
            long count = this.commentDAO.count((Specification)specification);
            Message message = (Message)this.messageDAO.findById(messageId).get();
            message.setCommentCount((int)count);
            this.messageDAO.save(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public DataPackage<Comment> queryComments4Message(final String messageId, Integer page, Integer lines, final IUser user) throws Exception {
        DataPackage dp = new DataPackage();
        dp.setPageNo(page.intValue());
        dp.setLinesPerPage(lines.intValue());
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)lines);
        try {
            Specification<Comment> specification = new Specification<Comment>(){

                public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                    ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                    if (messageId != null && !messageId.equals("")) {
                        predicates.add(cb.equal((Expression)root.get("messageId"), (Object)messageId));
                    }
                    if (user.getDomainid() != null && !user.getDomainid().equals("")) {
                        predicates.add(cb.equal((Expression)root.get("domainid"), (Object)user.getDomainid()));
                    }
                    Predicate[] pre = new Predicate[predicates.size()];
                    query.where(predicates.toArray(pre));
                    return cb.and(predicates.toArray(pre));
                }
            };
            long count = this.commentDAO.count((Specification)specification);
            List list = this.commentDAO.findAll((Specification)specification, (Pageable)pageable).getContent();
            dp.setRowCount((int)count);
            dp.setDatas((Collection)list);
            this.setComment2Read((DataPackage<Comment>)dp, user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dp;
    }

    @Override
    public DataPackage<Comment> queryCommentIReply(final String content, int page, int lines, final IUser user) throws Exception {
        DataPackage dp = new DataPackage();
        dp.setPageNo(page);
        dp.setLinesPerPage(lines);
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)lines);
        Specification<Comment> specification = new Specification<Comment>(){

            public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (user.getId() != null && !user.getId().equals("")) {
                    predicates.add(cb.equal((Expression)root.get("senderId"), (Object)user.getId()));
                }
                if (user.getDomainid() != null && !user.getDomainid().equals("")) {
                    predicates.add(cb.equal((Expression)root.get("domainid"), (Object)user.getDomainid()));
                }
                if (!StringUtil.isBlank((String)content)) {
                    predicates.add(cb.like((Expression)root.get("content"), "%" + content + "%"));
                }
                Predicate[] pre = new Predicate[predicates.size()];
                query.where(predicates.toArray(pre));
                return cb.and(predicates.toArray(pre));
            }
        };
        List list = this.commentDAO.findAll((Specification)specification, (Pageable)pageable).getContent();
        dp.setDatas((Collection)list);
        long count = this.commentDAO.count((Specification)specification);
        dp.setRowCount((int)count);
        return dp;
    }

    @Override
    public DataPackage<Comment> queryCommentIReceive(final String content, int page, int lines, final IUser user) throws Exception {
        DataPackage dp = new DataPackage();
        dp.setPageNo(page);
        dp.setLinesPerPage(lines);
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)lines);
        try {
            Specification<Comment> specification = new Specification<Comment>(){

                public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                    ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                    if (user.getId() != null && !user.getId().equals("")) {
                        predicates.add(cb.equal((Expression)root.get("toUserId"), (Object)user.getId()));
                    }
                    if (user.getDomainid() != null && !user.getDomainid().equals("")) {
                        predicates.add(cb.equal((Expression)root.get("domainid"), (Object)user.getDomainid()));
                    }
                    if (!StringUtil.isBlank((String)content)) {
                        predicates.add(cb.like((Expression)root.get("content"), "%" + content + "%"));
                    }
                    Predicate[] pre = new Predicate[predicates.size()];
                    query.where(predicates.toArray(pre));
                    return cb.and(predicates.toArray(pre));
                }
            };
            List list = this.commentDAO.findAll((Specification)specification, (Pageable)pageable).getContent();
            dp.setDatas((Collection)list);
            long count = this.commentDAO.count((Specification)specification);
            dp.setRowCount((int)count);
            this.setComment2Read((DataPackage<Comment>)dp, user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dp;
    }

    private void setComment2Read(DataPackage<Comment> datas, IUser user) throws Exception {
        if (!datas.getDatas().isEmpty()) {
            Collection comments = datas.getDatas();
            ArrayList<Comment> data = new ArrayList<Comment>();
            for (Comment comment : comments) {
                if (comment.isRead() || !comment.getToUserId().equals(user.getId())) continue;
                data.add(comment);
                this.notificationDAO.deleteAllByMessageId(comment.getId());
            }
            this.commentDAO.saveAll(data);
        }
    }

    @Override
    public AuthtimeValueObject doCreate(AuthtimeValueObject vo) throws Exception {
        return null;
    }

    @Override
    public AuthtimeValueObject doUpdate(AuthtimeValueObject vo) throws Exception {
        return null;
    }

    @Override
    public AuthtimeValueObject doView(String pk) throws Exception {
        return null;
    }

    @Override
    public void doRemove(String pk) throws Exception {
    }

    @Override
    public void doRemove(String[] pk) throws Exception {
    }

    @Override
    public DataPackage<Comment> doQuery(ParamsTable params, IUser user) throws Exception {
        return null;
    }
}

