/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.base.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.conf.FeignConfig;
import cn.myapps.conf.UserAPI;
import cn.myapps.message.base.service.BaseProcess;
import com.bcxin.saas.core.Constants;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="MessageBaseController")
public abstract class BaseController<E> {
    protected static final String ACTION_RESULT_KEY = "status";
    protected static final int ACTION_RESULT_VALUE_SUCCESS = 1;
    protected static final int ACTION_RESULT_VALUE_FAULT = 0;
    private static final String PARAM_WEB_USER = "PARAM_WEB_USER";
    protected static final String ACTION_MESSAGE_KEY = "message";
    protected static final String ACTION_DATA_KEY = "data";
    protected Map<String, Object> dataMap = new HashMap<String, Object>();
    protected String[] _selects = null;
    protected ParamsTable params;
    protected AuthtimeValueObject content = null;
    protected BaseProcess<E> process = null;
    protected DataPackage<E> datas = null;
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpServletResponse response;
    @Autowired
    protected HttpSession session;
    @Autowired
    protected DistributedCacheProvider distributedCacheProvider;

    public String[] get_selects() {
        return this._selects;
    }

    public void set_selects(String[] selects) {
        this._selects = selects;
    }

    public ParamsTable getParams() {
        if (this.params == null) {
            this.params = ParamsTable.convertHTTP((HttpServletRequest)this.request);
            this.params.setSessionid(this.request.getSession().getId());
            if (this.params.getParameter("_pagelines") == null) {
                this.params.setParameter("_pagelines", (Object)"10");
            }
        }
        return this.params;
    }

    public ParamsTable getParams(HttpServletRequest request) {
        if (this.params == null) {
            this.params = ParamsTable.convertHTTP((HttpServletRequest)request);
            this.params.setSessionid(request.getSession().getId());
            if (this.params.getParameter("_pagelines") == null) {
                this.params.setParameter("_pagelines", (Object)"10");
            }
        }
        return this.params;
    }

    public String getUserId() {
        String userId = Security.getUserIdFromToken((HttpServletRequest)this.request);
        if (userId == null) {
            userId = Security.getDebugUserIdFromToken((HttpServletRequest)this.request);
        }
        return userId;
    }

    public AuthtimeValueObject getContent() {
        return this.content;
    }

    public void setContent(AuthtimeValueObject content) {
        this.content = content;
    }

    public DataPackage<E> getDatas() {
        return this.datas;
    }

    public void setDatas(DataPackage<E> datas) {
        this.datas = datas;
    }

    public WebUser getUser() throws Exception {
        if (this.request.getAttribute(PARAM_WEB_USER) == null) {
            WebUser user = new WebUser();
            String userId = Security.getUserIdFromToken((HttpServletRequest)this.request);
            if (StringUtils.isEmpty((String)userId)) {
                return null;
            }
            Map userMap = (Map)this.distributedCacheProvider.get(Constants.getUserMapRedisKey((String)userId), () -> {
                FeignConfig.ACCESS_TOKEN = this.getTokenByCookie(this.request, "accessToken");
                if (StringUtils.isEmpty((String)FeignConfig.ACCESS_TOKEN)) {
                    FeignConfig.ACCESS_TOKEN = Security.getToken((String)userId);
                }
                UserAPI userAPI = (UserAPI)SpringApplicationContextUtil.getBean(UserAPI.class);
                Map userMap_1 = null;
                try {
                    userMap_1 = (Map)userAPI.getLoginUser().getData();
                }
                catch (Exception e) {
                    throw new SaasBadException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u65e0\u6548", e);
                }
                return userMap_1;
            }, 300L);
            user.setId(userId);
            user.setName((String)userMap.get("name"));
            user.setDomainid((String)userMap.get("domainId"));
            user.setDefaultDepartment((String)userMap.get("deptId"));
            this.request.setAttribute(PARAM_WEB_USER, (Object)user);
        }
        return (WebUser)this.request.getAttribute(PARAM_WEB_USER);
    }

    public BaseProcess<E> getProcess() {
        return this.process;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public Map<String, Object> addActionResult(boolean isSuccess, String message, Object data) {
        this.dataMap.put(ACTION_RESULT_KEY, isSuccess ? 1 : 0);
        this.dataMap.put(ACTION_MESSAGE_KEY, message);
        if (data != null) {
            this.dataMap.put(ACTION_DATA_KEY, data);
        }
        return this.dataMap;
    }

    private WebUser getAnonymousUser() {
        WebUser vo = new WebUser();
        vo.setId("1234-5678-90");
        vo.setName("\u6d4b\u8bd5\u7528\u6237");
        vo.setLoginpwd("");
        return vo;
    }

    public String getTokenByCookie(HttpServletRequest request, String key) {
        String accessToken = null;
        try {
            accessToken = request.getParameter(key);
            if (accessToken == null) {
                accessToken = request.getHeader(key);
            }
            if (accessToken == null) {
                Cookie[] cookies = request.getCookies();
                if (cookies == null) {
                    return null;
                }
                for (Cookie cookie : cookies) {
                    String name = cookie.getName();
                    if (!key.equals(name)) continue;
                    accessToken = cookie.getValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return accessToken;
    }
}

