/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.caches;

import cn.myapps.caches.requests.CacheRequest;
import cn.myapps.caches.responses.CacheResponse;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/caches"})
@Api(tags={"\u7f13\u5b58\u4fe1\u606f"})
public class CacheController {
    private final StringRedisTemplate redisTemplate;
    private final JsonProvider jsonProvider;

    public CacheController(StringRedisTemplate redisTemplate, JsonProvider jsonProvider) {
        this.redisTemplate = redisTemplate;
        this.jsonProvider = jsonProvider;
    }

    @GetMapping(value={"/{key}"})
    @ApiOperation(value="\u83b7\u53d6\u7f13\u5b58\u4fe1\u606f", notes="\u83b7\u53d6\u7f13\u5b58\u4fe1\u606f")
    public ResponseEntity<CacheResponse> get(@PathVariable String key) {
        if (!StringUtils.hasLength((String)key)) {
            throw new SaasBadException("\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        String content = (String)this.redisTemplate.opsForValue().get((Object)CacheController.getCacheKey(key));
        CacheItem cacheItem = (CacheItem)this.jsonProvider.getData(content, CacheItem.class);
        if (cacheItem == null) {
            return ResponseEntity.ok(null);
        }
        return ResponseEntity.ok((Object)((Object)CacheResponse.create(cacheItem.getCode(), cacheItem.getData())));
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u7f13\u5b58\u4fe1\u606f", notes="\u65b0\u589e\u7f13\u5b58\u4fe1\u606f")
    public ResponseEntity post(@RequestBody CacheRequest request) {
        if (!StringUtils.hasLength((String)request.getKey())) {
            throw new SaasBadException("\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        String cacheKey = CacheController.getCacheKey(request.getKey());
        String content = this.jsonProvider.getJson((Object)CacheItem.create(request.getCode(), request.getData()));
        if (request.getExpiredInSeconds() == null || request.getExpiredInSeconds() < 0) {
            this.redisTemplate.opsForValue().set((Object)cacheKey, (Object)content);
        } else {
            this.redisTemplate.opsForValue().set((Object)cacheKey, (Object)content, Duration.of(request.getExpiredInSeconds().intValue(), ChronoUnit.SECONDS));
        }
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{key}"})
    @ApiOperation(value="\u5220\u9664\u6307\u5b9a\u7f13\u5b58", notes="\u5220\u9664\u6307\u5b9a\u7f13\u5b58")
    public ResponseEntity delete(@PathVariable String key) {
        this.redisTemplate.delete((Object)CacheController.getCacheKey(key));
        return ResponseEntity.ok().build();
    }

    private static String getCacheKey(String key) {
        return String.format("msg:cache:data:%s", key);
    }

    public static class CacheItem
    implements Serializable {
        private String code;
        private Object data;

        public static CacheItem create(String code, Object data) {
            CacheItem item = new CacheItem();
            item.setData(data);
            item.setCode(code);
            return item;
        }

        public String getCode() {
            return this.code;
        }

        public Object getData() {
            return this.data;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheItem)) {
                return false;
            }
            CacheItem other = (CacheItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "CacheController.CacheItem(code=" + this.getCode() + ", data=" + this.getData() + ")";
        }
    }
}

