package cn.myapps.runtime.mobile.notice.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.message.base.controller.BaseController;
import cn.myapps.message.notice.model.Notice;
import cn.myapps.message.notice.service.NoticeProcess;
import cn.myapps.message.notice.service.NoticeProcessBean;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;

@Controller(value="NoticeController")
@RequestMapping(value="/api/runtime/app/notice")
@Scope("prototype")
@Api(tags = "手机获取通知模块(不知道此类在那里用到)")
public class NoticeController extends BaseController{
	
	/**
	 * 获取通知
	 */
	@RequestMapping(value="/list.action")
	@ResponseBody
	@ApiOperation(value = "获取手机通知集合", notes = "获取手机通知集合")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "access_token",value = "access_token",required = true,paramType = "query",dataType = "string")
	})
	public Map<String, Object> doList(){
		if (getUserId() == null) {
			return addActionResult(false, "access_token invalid", null);
		}

		//todo deleted by hc
		return addActionResult(true, "ok", new ArrayList<Map<String,Object>>());
		/*
	   try {
		   IUser user = getUser();
		   	NoticeProcess process = new NoticeProcessBean();
		    DataPackage<Notice> data = process.queryNoticeByCondition("", false, 0, 1, Integer.MAX_VALUE, user.getId());
		    List<Map<String, Object>> result = new ArrayList<Map<String,Object>>();
		    for (Iterator<Notice> iterator = data.datas.iterator(); iterator.hasNext(); ) {
		    	Notice notice = iterator.next();
		    	Map<String, Object> map = new HashMap<String, Object>();
		    	map.put("id", notice.getId());
		    	if (StringUtils.isBlank(notice.getContent())) {
		    		map.put("content", new JSONObject());
				}else{
					map.put("content", JSONObject.fromObject(notice.getContent()));
				}
		    	if (StringUtils.isBlank(notice.getLinkParams())) {
		    		map.put("linkParams", new JSONObject());
				}else{
					map.put("linkParams", JSONObject.fromObject(notice.getLinkParams()));
				}
		    	map.put("toUserId", notice.getToUserId());
		    	SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		    	String createTime = formatter.format(notice.getCreateTime());
		    	map.put("createTime", createTime);
		    	map.put("read", false);
		    	map.put("module", notice.getModule());
		    	map.put("subjectType", notice.getSubjectType());
		    	map.put("messageType", 1);
		    	result.add(map);
			}
		    return addActionResult(true, "ok", result);
		} catch (Exception e) {
			return addActionResult(false, e.getMessage(), null);
		}

		 */
	}
	
	/**
     * 删除通知
     */
	@RequestMapping(value="/delete.action")
	@ResponseBody
	@ApiOperation(value = "删除手机通知", notes = "删除手机通知")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "id",value = "用户id",required = true,paramType = "query",dataType = "string")
	})
	public Map<String, Object> doDelete(){
		 try {
			    ParamsTable params = getParams();
			    String id = params.getParameterAsString("id");
			    NoticeProcess process = new NoticeProcessBean();
			    process.doRemove(id);
			    return addActionResult(true, "ok", null);
			} catch (Exception e) {
				return addActionResult(false, e.getMessage(), null);
			}
	}
	
	 /**
     * 标记已读
     */
	@RequestMapping(value="/read.action")
	@ResponseBody
	@ApiOperation(value = "标记已读", notes = "标记已读")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "access_token",value = "access_token",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "ids",value = "联系人主键",required = true,paramType = "query",dataType = "string")
	})
	public Map<String, Object> doRead(){
		try {
		    ParamsTable params = getParams();
		    String ids = params.getParameterAsString("ids");
		    NoticeProcess process = new NoticeProcessBean();
		    process.setNotice2Read(ids);
		    return addActionResult(true, "ok", null);
		} catch (Exception e) {
			return addActionResult(false, e.getMessage(), null);
		}
	}
}
