package cn.myapps.runtime.message.service;

import java.util.Map;

import cn.myapps.base.web.WebUser;

/**
 * 消息中心服务接口
 * @author spy
 */
public interface MessageRunTimeService {

	/**
	 * 获取通知事项
	 * @param user
	 * 		当前登陆用户对象
	 * @param pageNo
	 * 		当前页
	 * @param linesPerPage
	 * 		每页显示条数
	 * @return
	 * 		通知事项集合
	 * @throws Exception
	 */
	Map<String, Object> getNotices(String userId, Integer pageNo, Integer linesPerPage) throws Exception;

	/**
	 * 标记已读
	 * @param id
	 * 		通知id
	 * @throws Exception
	 */
	void set2Read(String id) throws Exception;

	/**
	 * 标记全部已读
	 * @param user
	 * 		当前登陆用户对象
	 * @throws Exception
	 */
	void setAll2Read(String userId) throws Exception;

	/**
	 * 删除通知（可批量）
	 * @param ids
	 * 		通知id集合
	 * @throws Exception
	 */
	void delete(String[] ids) throws Exception;

}
