package cn.myapps.runtime.message.controller;

import static com.jayway.jsonpath.JsonPath.parse;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.myapps.AbstractRuntimeController;
import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.message.service.MessageRunTimeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

/**
 * messages RESTful
 * @author spy
 */
@Api(tags = "消息中心执行模块")
@Component
@RequestMapping(path = "/runtime/messages", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class MessageController extends AbstractRuntimeController {
	
	@Autowired
	private MessageRunTimeService messageService;
	
	/**
	 * 获取通知事项
	 * @param pageNo 当前页
	 * @param linesPerPage 每页显示条数
	 * @return
	 * @throws Exception
	 */
	@GetMapping("/notices")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "运行执行前脚本", notes = "运行执行前脚本")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "pageNo",value = "当前页",required = false,paramType = "query",dataType = "int",defaultValue="1"),
		@ApiImplicitParam(name = "linesPerPage",value = "每页显示条数",required = false,paramType = "query",dataType = "int",defaultValue="10")
	})
	public Resource getNotices(@RequestParam(required = false,defaultValue="1") Integer pageNo, @RequestParam(required = false,defaultValue="10") Integer linesPerPage) throws Exception {
		Map<String, Object> result = messageService.getNotices(getUser().getId(), pageNo, linesPerPage);
		return success("ok", result);
	}
	
	/**
	 * 标记已读
	 * @param id 标记id
	 * @return
	 * @throws Exception
	 */
	@PutMapping("/notices/{id}/read")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "标记已读", notes = "标记已读")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "id",value = "通知id",required = true,paramType = "path",dataType = "string")
	})
	public Resource set2Read(@PathVariable String id) throws Exception {
		messageService.set2Read(id);
		return success("ok", null);
	}
	
	/**
	 * 标记全部已读
	 * @return
	 * @throws Exception
	 */
	@PutMapping("/notices/read")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "标记全部已读", notes = "标记全部已读")
	public Resource setAll2Read() throws Exception {
		messageService.setAll2Read(getUser().getId());
		return success("ok", null);
	}
	
	/**
	 * 删除通知（可批量)
	 * @param content 请求包体
	 * @return
	 * @throws Exception
	 */
	@DeleteMapping("/notices/delete")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "删除通知（可批量)", notes = "删除通知（可批量)")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string")
	})
	public Resource delete(@RequestBody String content) throws Exception {
		List<String> ids= parse(content).json();
		String[] idArray = {};
		idArray = ids.toArray(idArray);
		messageService.delete(idArray);
		return success("ok", null);
	}
}
