package cn.myapps.message.util;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import cn.myapps.common.util.DbUtil;
import com.bcxin.saas.core.components.SecondCacheProvider;
import cn.myapps.common.util.SpringApplicationContextUtil;

/**
 * 数据库连接管理器
 * <p>管理Connection 对象的创建、缓存、关闭</p>
 * 
 * @author Happy
 *
 */
public class ConnectionManager {
	public static final String DS_DEFAULT_CONNECTION="DS:DS_DEFAULT:CONNECTION";
	public static String dbType = "MYSQL";
	
	/**
	 * 获取数据库连接对象
	 * @return
	 * 		java.sql.Connection
	 * @throws Exception
	 */
	public static Connection getConnection() throws Exception {
		Connection threadLocal = getRuntimeDefaultDBConn();
		Connection conn = null;
		if (threadLocal != null) {
			conn = threadLocal;
		}
		if (conn == null || conn.isClosed()) {
			conn = newConnection();
			if(conn !=null)
				setRuntimeDefaultDBConn(conn);
		}
		
		return conn;
	}
	
	/**
	 * 实例化数据库连接对象
	 * <p>读取“proxool.properties”文件获取obpm系统库的数据源信息，创建数据库连接对象。</p>
	 * @return
	 * 		java.sql.Connection
	 * @throws Exception
	 */
	private static Connection newConnection() throws Exception {

		DataSource dataSource = SpringApplicationContextUtil.getBean(javax.sql.DataSource.class);
		if (dataSource != null) {
			Connection conn = dataSource.getConnection();
			dbType = DbUtil.getDBType(conn);
			return conn;
		}

		return null;
	}
	
	/**
	 * 关闭Statement
	 * @param stmt
	 * @throws Exception
	 */
	public static void closeStatement(Statement stmt) throws Exception {
		try {
			if (stmt != null) {
				stmt.close();
			}
		} catch (SQLException se) {
			throw new Exception("SQL Exception while closing " + "Statement : \n" + se);
		}
	}
	
	/**
	 * 关闭数据库连接
	 * @throws Exception
	 */
	private volatile static int closeCount = 0;
	public static void closeConnection() throws Exception {
		try {
			Connection threadLocal = getRuntimeDefaultDBConn();
			if (threadLocal != null) {
					if (!threadLocal.isClosed()) {
						closeCount ++;
						threadLocal.close();
					}
				threadLocal = null;

				setRuntimeDefaultDBConn(null);
			}
			
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	private static Connection getRuntimeDefaultDBConn() throws Exception {
		SecondCacheProvider secondCacheProvider = SpringApplicationContextUtil.getBean(SecondCacheProvider.class);
		Connection connection = (Connection)
				secondCacheProvider.getIfPresent(DS_DEFAULT_CONNECTION);

		return connection;
	}

	private static void setRuntimeDefaultDBConn(Connection connection) {
		SecondCacheProvider secondCacheProvider = SpringApplicationContextUtil.getBean(SecondCacheProvider.class);
		if (connection == null) {
			secondCacheProvider.removeData(DS_DEFAULT_CONNECTION);
		} else {
			secondCacheProvider.setData(DS_DEFAULT_CONNECTION, connection);
		}
	}
}
