package cn.myapps.message.notification.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.conf.UserAPI;
import cn.myapps.message.base.service.BaseProcess;
import cn.myapps.message.comment.dao.CommentDAO;
import cn.myapps.message.comment.model.Comment;
import cn.myapps.message.message.model.Message;
import cn.myapps.message.notice.dao.NoticeDAO;
import cn.myapps.message.notice.model.Notice;
import cn.myapps.message.notification.dao.NotificationDAO;
import cn.myapps.message.notification.model.Notification;
import cn.myapps.message.util.sequence.Sequence;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

@Service
public class NotificationProcessBean  implements BaseProcess<Notification>, NotificationProcess {

	@Autowired
	private NotificationDAO notificationDAO;

	@Autowired
	private NoticeDAO noticeDAO;

	@Autowired
	private CommentDAO commentDAO;
	
	@Override
	public void doCreateMessagesNotification(Message message, String domainid, IUser user)throws Exception {

		try {
			if(message !=null){
				Collection<Notification> notifications = null ;
				if(message.getType() == Message.TYPE_STANDARD){ //普通消息类型  //@功能
					
				}else if(message.getType() == Message.TYPE_ANNOUNCEMENT){ //通知公告类型
					String receiverId = message.getReceiverId();
					if(message.getScope() == Message.SCOPE_ALL){
						UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
						Collection departmentUsers = userAPI.getDomainUsers(domainid);
						JSONArray array = JSONArray.fromObject(departmentUsers);
						notifications = new ArrayList<Notification>();
						for(Object object : array ){
							JSONObject json = JSONObject.fromObject(object);
							Notification notice = new Notification();
							notice.setId(Sequence.getSequence());
							String linkParams = null ;
							//TODO 消息和公告在后期优化的时候需要区分
							notice.setSummary(message.getTitle()); 
							notice.setLinkParams(linkParams); //链接地址
							notice.setMessageId(message.getId());
							notice.setMessageType(Notification.TYPE_ANNOUNCEMENT);
							notice.setModule(Message.MODULE_MESSAGE);
							notice.setSender(message.getSender());
							notice.setSenderId(message.getSenderId());
							notice.setReceiverId((String) json.get("id"));
							notice.setDomainid(domainid);
							notice.setCreateTime(new Date());
							notifications.add(notice);
						}
					}else if(message.getScope() == Message.SCOPE_CUSTOM){
						if(!StringUtil.isBlank(receiverId)){
							notifications = new ArrayList<Notification>();
							for(String userId : receiverId.split(",")){
								Notification notice = new Notification();
								notice.setId(Sequence.getSequence());
								String linkParams = null ;
								//TODO 消息和公告在后期优化的时候需要区分
								notice.setSummary(message.getTitle()); 
								notice.setLinkParams(linkParams); //链接地址
								notice.setMessageId(message.getId());
								notice.setMessageType(Notification.TYPE_ANNOUNCEMENT);
								notice.setModule(Message.MODULE_MESSAGE);
								notice.setSender(message.getSender());
								notice.setSenderId(message.getSenderId());
								notice.setReceiverId(userId);
								notice.setDomainid(domainid);
								notice.setCreateTime(new Date());
								notifications.add(notice);
							}
						}
					}
					
				}else if(message.getType() == Message.TYPE_WORK_REMIND){
					
				}
				if(notifications!=null){
					notificationDAO.saveAll(notifications);
				}
			}
		} catch (Exception e) {
			throw e;
		}
	}
	
	@Override
	public void doCreateCommentNotification(Comment comment,String domainId, IUser user)  throws Exception {
		try {
			if(comment !=null){
				Notification notice = new Notification();
				notice.setId(Sequence.getSequence());
				String linkParams = null ;
				notice.setSummary(comment.getContent());
				notice.setLinkParams(linkParams); //链接地址
				notice.setMessageId(comment.getMessageId());
				notice.setMessageType(Notification.TYPE_COMMENT);
				notice.setModule(Message.MODULE_MESSAGE);
				notice.setReceiverId(comment.getToUserId());
				notice.setSender(comment.getSender());
				notice.setSenderId(comment.getSenderId());
				notice.setCreateTime(new Date());
				notice.setDomainid(domainId);
				notificationDAO.save(notice);
			}
		} catch (Exception e) {
			throw e;
		}
	}

	@Override
	public void doCreateNoticeNotification(Notice notice, String domainId,IUser user) throws Exception {
		try {
			if(notice !=null){
				Notification notification = new Notification();
				notification.setId(Sequence.getSequence());
				notification.setLinkParams(notice.getLinkParams()); 
				notification.setMessageId(notice.getId());
				notification.setMessageType(Notification.TYPE_NOTICE);
				notification.setModule(notice.getModule());
				notification.setReceiverId(notice.getToUserId());
				notification.setSummary(notice.getSummary());
				notification.setDomainid(domainId);
				notification.setSender(user.getName());
				notification.setSenderId(user.getId());
				notification.setCreateTime(notice.getCreateTime());
				notificationDAO.save(notification);
			}
		} catch (Exception e) {
			throw e;
		}
	}


	@Override
	public JSONObject sendMessageNotification2User(String userId)throws Exception {
		JSONObject result = new JSONObject();
		Collection<Notification> notifications = null;
		notifications = notificationDAO.queryNotificationsByTimer(userId);
		notificationDAO.deleteAllByReceiverId(userId);
		Specification noticeSpecification = new Specification<Notice>() {
			@Override
			public Predicate toPredicate(Root<Notice> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
				List<Predicate> predicates = new ArrayList<>();
				if (StringUtil.isBlank(userId)) {
					predicates.add(cb.equal(root.get("toUserId"), userId));
				}
				predicates.add(cb.equal(root.get("read"), 1));
				Predicate[] pre = new Predicate[predicates.size()];
				query.where(predicates.toArray(pre));
				return cb.and(predicates.toArray(pre));
			}
		};

		Specification commentSpecification = new Specification<Comment>() {
			@Override
			public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
				List<Predicate> predicates = new ArrayList<>();
				if (StringUtil.isBlank(userId)) {
					predicates.add(cb.equal(root.get("toUserId"), userId));
				}
				predicates.add(cb.equal(root.get("read"), 1));
				Predicate[] pre = new Predicate[predicates.size()];
				query.where(predicates.toArray(pre));
				return cb.and(predicates.toArray(pre));
			}
		};

		result.put("data", notifications);
		JSONObject amount = new JSONObject();
		int notice = (int) noticeDAO.count(noticeSpecification);
		int comment = (int) commentDAO.count(commentSpecification);
		amount.put("notice", notice);
		amount.put("comment", comment);
		amount.put("sum", comment + notice);
		result.put("amount", amount);

		return result;
	}


	@Override
	public JSONObject sendMessageNotificationWhenLogin(String userId) throws Exception {
		JSONObject result = new JSONObject();
		Collection<Notification> notifications = null ;
		try {
			List list = notificationDAO.queryNotificationCountByReceiverIdGroupByMessageType(userId);
			int rowCount = 0;
			for (Object row:list){
				Object[] cells = (Object[]) row;
				int type = (int) cells[0];
				if(Notification.TYPE_NOTICE != type && Notification.TYPE_COMMENT != type ){ //事项提醒从MC_NOTICE表中获取
					int nums = (int) cells[1];
					rowCount+=nums;
					result.put(type, nums);
				}
			}
			notificationDAO.deleteAllByReceiverId(userId);
			Specification noticeSpecification = new Specification<Notice>() {
				@Override
				public Predicate toPredicate(Root<Notice> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
					List<Predicate> predicates = new ArrayList<>();
					if (!StringUtil.isBlank(userId)) {
						predicates.add(cb.equal(root.get("toUserId"),userId));
					}
					predicates.add(cb.equal(root.get("read"),0));
					Predicate[] pre = new Predicate[predicates.size()];
					query.where(predicates.toArray(pre));
					return cb.and(predicates.toArray(pre));
				}
			};

			Specification commentSpecification = new Specification<Comment>() {
				@Override
				public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
					List<Predicate> predicates = new ArrayList<>();
					if (!StringUtil.isBlank(userId)) {
						predicates.add(cb.equal(root.get("toUserId"),userId));
					}
					predicates.add(cb.equal(root.get("read"),0));
					Predicate[] pre = new Predicate[predicates.size()];
					query.where(predicates.toArray(pre));
					return cb.and(predicates.toArray(pre));
				}
			};
			int notice = (int)noticeDAO.count(noticeSpecification);
			int comment = (int) commentDAO.count(commentSpecification);
			result.put(Notification.TYPE_NOTICE, notice);
			result.put(Notification.TYPE_COMMENT, comment);
			result.put("size", rowCount+notice+comment);
		} catch (Exception e) {
			throw e;
		}
		return result;
	}


	@Override
	public void clearMessageNotification(Integer type,String messageId,Boolean isSend,String userId)throws Exception {
		try {
			Specification specification = new Specification<Notification>() {
				@Override
				public Predicate toPredicate(Root<Notification> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
					List<Predicate> predicates = new ArrayList<>();
					if (userId != null && !userId.equals("")) {
						predicates.add(cb.equal(root.get("receiverId"),userId));
					}
					if(type!=null){
						predicates.add(cb.equal(root.get("messageType"),Integer.toString(type)));
					}
					if(!StringUtil.isBlank(messageId)){
						predicates.add(cb.equal(root.get("messageId"),messageId));
					}
					Predicate[] pre = new Predicate[predicates.size()];
					query.where(predicates.toArray(pre));
					return cb.and(predicates.toArray(pre));
				}
			};
			List<Notification> all = notificationDAO.findAll(specification);
			notificationDAO.deleteInBatch(all);
		} catch (Exception e) {
			throw e;
		}
	}

	@Override
	public JSONObject getNotificationCount(String userId) throws Exception {
		JSONObject result = new JSONObject();

		int notice = 0;
		int comment = 0;

		if (StringUtils.hasLength(userId)) {
			Specification noticeSpecification = new Specification<Notice>() {
				@Override
				public Predicate toPredicate(Root<Notice> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
					List<Predicate> predicates = new ArrayList<>();
					if (!StringUtil.isBlank(userId)) {
						predicates.add(cb.equal(root.get("toUserId"), userId));
					}
					predicates.add(cb.equal(root.get("read"), 0));
					Predicate[] pre = new Predicate[predicates.size()];
					query.where(predicates.toArray(pre));
					return cb.and(predicates.toArray(pre));
				}
			};

			Specification commentSpecification = new Specification<Comment>() {
				@Override
				public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
					List<Predicate> predicates = new ArrayList<>();
					if (!StringUtil.isBlank(userId)) {
						predicates.add(cb.equal(root.get("toUserId"), userId));
					}
					predicates.add(cb.equal(root.get("read"), 0));
					Predicate[] pre = new Predicate[predicates.size()];
					query.where(predicates.toArray(pre));
					return cb.and(predicates.toArray(pre));
				}
			};

			notice = (int) noticeDAO.count(noticeSpecification);
			comment = (int) commentDAO.count(commentSpecification);
		}

		result.put("notice", notice);
		result.put("comment", comment);
		result.put("sum", notice + comment);

		return result;
	}

	@Override
	public void doCreateNotification4PerssonalMessage(
			Message message,String domainid, IUser user) throws Exception {
		try {
			if(message !=null){
				Collection<Notification> notifications = null ;
				notifications = new ArrayList<Notification>();
				String receiverId = message.getReceiverId();
				for(String userId : receiverId.split(",")){
					Notification notice = new Notification();
					notice.setId(Sequence.getSequence());
					String linkParams = null ;
					notice.setSummary(message.getTitle()+":"+message.getContent()); 
					notice.setLinkParams(linkParams); //链接地址
					notice.setMessageId(message.getId());
					notice.setMessageType(Notification.TYPE_MESSAGE);
					notice.setModule(Message.MODULE_MESSAGE);
					notice.setSender(message.getSender());
					notice.setSenderId(message.getSenderId());
					notice.setReceiverId(userId);
					notice.setDomainid(domainid);
					notice.setCreateTime(new Date());
					notifications.add(notice);
				}
				if(notifications!=null){
					notificationDAO.saveAll(notifications);
				}
			}
		} catch (Exception e) {
			throw e;
		}
	}

	@Override
	public AuthtimeValueObject doCreate(AuthtimeValueObject vo) throws Exception {
		return null;
	}

	@Override
	public AuthtimeValueObject doUpdate(AuthtimeValueObject vo) throws Exception {
		return null;
	}

	@Override
	public AuthtimeValueObject doView(String pk) throws Exception {
		return null;
	}

	@Override
	public void doRemove(String pk) throws Exception {

	}

	@Override
	public void doRemove(String[] pk) throws Exception {

	}

	@Override
	public DataPackage<Notification> doQuery(ParamsTable params, IUser user) throws Exception {
		return null;
	}
}
