package cn.myapps.message.notification.service;

import cn.myapps.common.auth.IUser;
import cn.myapps.message.base.service.BaseProcess;
import cn.myapps.message.comment.model.Comment;
import cn.myapps.message.message.model.Message;
import cn.myapps.message.notice.model.Notice;
import cn.myapps.message.notification.model.Notification;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public interface NotificationProcess extends BaseProcess<Notification> {

	/**
	 * 登陆时消息提醒功能
	 * 
	 * @param user
	 * @return
	 */
	public JSONObject sendMessageNotificationWhenLogin(String userId) throws Exception;

	/**
	 * 发送消息通知(前台请求)
	 * 
	 * @param user
	 * @throws Exception
	 */
	public JSONObject sendMessageNotification2User(String userId) throws Exception;

	/**
	 * 清空消息通知
	 * 
	 * @param type      消息通知类型(null时清空用户所有消息)
	 * @param messageId 消息id(null时为清空该类型下所有消息)
	 * @param isSend    消息是否发送
	 * @param user      用户
	 * @throws Exception
	 */
	public void clearMessageNotification(Integer type, String messageId, Boolean isSend, String userId) throws Exception;

	/**
	 * 生成消息通知
	 * 
	 * @param message
	 * @param domianid
	 * @param user
	 * @throws Exception
	 */
	public void doCreateMessagesNotification(Message message, String domianid, IUser user) throws Exception;

	/**
	 * 生成评论通知
	 * 
	 * @param comment
	 * @param domainId
	 * @param user
	 */
	public void doCreateCommentNotification(Comment comment, String domainId, IUser user) throws Exception;

	/**
	 * 生成事项通知
	 * 
	 * @param notice
	 * @param domainId
	 * @param user
	 * @throws Exception
	 */
	public void doCreateNoticeNotification(Notice notice, String domainId, IUser user) throws Exception;

	/**
	 * 获取所有事项的通知数
	 * 
	 * @param notice
	 * @param domainId
	 * @param user
	 * @throws Exception
	 */
	public JSONObject getNotificationCount(String userId) throws Exception;

	/**
	 * 生成站内短信
	 * 
	 * @param message
	 * @param domianid
	 * @param user
	 * @throws Exception
	 */
	public void doCreateNotification4PerssonalMessage(Message message, String domianid, IUser user) throws Exception;

}
