package cn.myapps.message.notification.dao;

import java.util.Collection;
import java.util.List;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.message.base.dao.BaseDAO;
import cn.myapps.message.notice.model.Notice;
import cn.myapps.message.notification.model.Notification;
import net.sf.json.JSONObject;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;


@Repository
public interface NotificationDAO extends JpaRepository<Notification,String>, JpaSpecificationExecutor<Notification> {

//	/**
//	 * 批量新建消息
//	 *
//	 * @param notifications
//	 */
//	public void createNotifications(Collection<Notification> notifications) throws Exception;
//
//	/**
//	 * 登陆时获取消息提醒
//	 *
//	 * @param user
//	 * @throws Exception
//	 */
//	public JSONObject queryNotificationsWhenLogin(IUser user) throws Exception;
//
	@Query("select sum(n.id) as typeNum,n.messageType from Notification n where n.receiverId =?1 group by n.messageType")
	public List queryNotificationCountByReceiverIdGroupByMessageType(String receiverId) throws Exception;
	/**
	 * 动态获取消息提醒(更新提醒发送状态)
	 *
	 * @param user
	 * @throws Exception
	 */
	@Query("select n from Notification n where n.receiverId = ?1")
	public Collection<Notification> queryNotificationsByTimer(String receiverId) throws Exception;

	@Transactional
	public void deleteAllByReceiverId(String receiverId);

	@Transactional
	public void deleteAllByMessageId(String messageId);
//
//	/**
//	 * 获取对应类型的通知消息数量
//	 *
//	 * @param type type为空时，找所有类型数量
//	 * @param user
//	 * @return
//	 * @throws Exception
//	 */
//	public Integer getNotificationsCountByType(Integer type, IUser user) throws Exception;
//
//	/**
//	 * 删除某种类型的消息通知
//	 *
//	 * @param type
//	 * @param user
//	 */
//	public void clearNotificationByMessage(Integer type, String messageId, Boolean isSend, String userId) throws Exception;
//
//	/**
//	 * 获取所有消息提醒数
//	 *
//	 * @param user
//	 * @return
//	 */
//	@Deprecated
//	public JSONObject getNotificationCount(IUser user) throws Exception;
//
//	/**
//	 * 获取所有消息提醒数
//	 */
//	public JSONObject getNotificationCounts(IUser user) throws Exception;

}
